/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.responsetypes.ConvertingResponseMessage;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.GenericQueryResponseMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConvertingResponseMessageTest {
    ConvertingResponseMessageTest() {
    }

    @Test
    void payloadIsConvertedToExpectedType() {
        GenericQueryResponseMessage msg = new GenericQueryResponseMessage((Object)new String[]{"Some string result"}).withMetaData((Map)MetaData.with((String)"test", (Object)"value"));
        ConvertingResponseMessage wrapped = new ConvertingResponseMessage(ResponseTypes.multipleInstancesOf(String.class), (QueryResponseMessage)msg);
        Assertions.assertEquals(List.class, (Object)wrapped.getPayloadType());
        Assertions.assertEquals(Collections.singletonList("Some string result"), (Object)wrapped.getPayload());
        Assertions.assertEquals((Object)"value", (Object)wrapped.getMetaData().get((Object)"test"));
    }

    @Test
    void illegalAccessPayloadWhenResultIsExceptional() {
        QueryResponseMessage msg = GenericQueryResponseMessage.asResponseMessage(List.class, (Throwable)new RuntimeException());
        ConvertingResponseMessage wrapped = new ConvertingResponseMessage(ResponseTypes.multipleInstancesOf(String.class), msg);
        Assertions.assertEquals(List.class, (Object)wrapped.getPayloadType());
        Assertions.assertThrows(IllegalPayloadAccessException.class, () -> ((QueryResponseMessage)wrapped).getPayload());
    }
}

