/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import java.util.concurrent.TimeUnit;
import org.axonframework.messaging.timeout.AxonTaskJanitor;
import org.axonframework.messaging.timeout.AxonTimeLimitedTask;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AxonTimeLimitedTaskTest {
    AxonTimeLimitedTaskTest() {
    }

    @AfterEach
    void tearDown() throws InterruptedException {
        AxonTaskJanitor.INSTANCE.awaitTermination(250L, TimeUnit.MILLISECONDS);
    }

    @Test
    void correctlyInterruptsTaskWhenNoWarningWasConfiguredOnUncustomizedConstructor() {
        AxonTimeLimitedTask testSubject = new AxonTimeLimitedTask("My test task", 100, 100, 1);
        Assertions.assertThrows(InterruptedException.class, () -> {
            testSubject.start();
            Thread.sleep(150L);
        });
        Assertions.assertTrue((boolean)testSubject.isInterrupted());
        Assertions.assertFalse((boolean)testSubject.isCompleted());
    }

    @Test
    void correctlyInterruptsTaskWithWarningWasConfiguredOnUncustomizedConstructor() {
        AxonTimeLimitedTask testSubject = new AxonTimeLimitedTask("My test task", 100, 50, 10);
        Assertions.assertThrows(InterruptedException.class, () -> {
            testSubject.start();
            Thread.sleep(150L);
        });
        Assertions.assertTrue((boolean)testSubject.isInterrupted());
        Assertions.assertFalse((boolean)testSubject.isCompleted());
    }

    @Test
    void correctlyLogsWarningsAndInterruptsWhenWarningWasConfiguredOnCustomizedConstructor() {
        Logger logger = (Logger)Mockito.spy((Object)LoggerFactory.getLogger((String)"MyLogger"));
        AxonTimeLimitedTask testSubject = new AxonTimeLimitedTask("My test task", 1000, 100, 100, AxonTaskJanitor.INSTANCE, logger);
        Assertions.assertThrows(InterruptedException.class, () -> {
            testSubject.start();
            Thread.sleep(1500L);
        });
        Assertions.assertTrue((boolean)testSubject.isInterrupted());
        Assertions.assertFalse((boolean)testSubject.isCompleted());
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.atLeast((int)8))).warn(Mockito.anyString(), new Object[]{Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any()});
    }

    @Test
    void doesNotInterruptButLogsWarningsIfProcessWasCompletedBeforeTimeout() throws InterruptedException {
        Logger logger = (Logger)Mockito.spy((Object)LoggerFactory.getLogger((String)"MyLogger"));
        AxonTimeLimitedTask testSubject = new AxonTimeLimitedTask("My test task", 1000, 100, 100, AxonTaskJanitor.INSTANCE, logger);
        testSubject.start();
        Thread.sleep(500L);
        Assertions.assertFalse((boolean)testSubject.isInterrupted());
        Assertions.assertFalse((boolean)testSubject.isCompleted());
        testSubject.complete();
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.atLeast((int)3))).warn(Mockito.anyString(), new Object[]{Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any()});
    }
}

