/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.awaitility.Awaitility;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.timeout.AxonTaskJanitor;
import org.axonframework.messaging.timeout.AxonTimeoutException;
import org.axonframework.messaging.timeout.TimeoutWrappedMessageHandlingMember;
import org.axonframework.messaging.timeout.UnitOfWorkTimeoutInterceptor;
import org.axonframework.messaging.unitofwork.BatchingUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CombinedTimeoutTests {
    CombinedTimeoutTests() {
    }

    @AfterEach
    void tearDown() throws InterruptedException {
        AxonTaskJanitor.INSTANCE.awaitTermination(250L, TimeUnit.MILLISECONDS);
    }

    @Test
    void onMessageHandlerInterruptWorks() {
        TimeoutWrappedMessageHandlingMember<Object> mhm = this.createMessageHandlingMember(100, () -> {
            Thread.sleep(200L);
            return null;
        });
        UnitOfWorkTimeoutInterceptor interceptor = this.createTimeoutInterceptor(500);
        List<EventMessage<?>> batch = this.generateBatch(2);
        BatchingUnitOfWork<?> uow = this.doExecution(batch, interceptor, mhm);
        Awaitility.await().until(() -> uow.isRolledBack());
        Assertions.assertInstanceOf(AxonTimeoutException.class, (Object)uow.getExecutionResult().getExceptionResult());
        Assertions.assertFalse((boolean)Thread.interrupted());
    }

    @Test
    void onUnitOfWorkInterruptWorks() {
        TimeoutWrappedMessageHandlingMember<Object> mhm = this.createMessageHandlingMember(500, () -> {
            Thread.sleep(200L);
            return null;
        });
        UnitOfWorkTimeoutInterceptor interceptor = this.createTimeoutInterceptor(100);
        List<EventMessage<?>> batch = this.generateBatch(2);
        BatchingUnitOfWork<?> uow = this.doExecution(batch, interceptor, mhm);
        Awaitility.await().until(() -> uow.isRolledBack());
        Assertions.assertInstanceOf(AxonTimeoutException.class, (Object)uow.getExecutionResult().getExceptionResult());
        Assertions.assertFalse((boolean)Thread.interrupted());
    }

    @Test
    void handlingMemberInterruptStillWorksIfExceptionIsWrapped() {
        TimeoutWrappedMessageHandlingMember<Object> mhm = this.createMessageHandlingMember(100, () -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Wrapped exception", e);
            }
            return null;
        });
        UnitOfWorkTimeoutInterceptor interceptor = this.createTimeoutInterceptor(500);
        List<EventMessage<?>> batch = this.generateBatch(2);
        BatchingUnitOfWork<?> uow = this.doExecution(batch, interceptor, mhm);
        Awaitility.await().until(() -> uow.isRolledBack());
        Assertions.assertInstanceOf(AxonTimeoutException.class, (Object)uow.getExecutionResult().getExceptionResult());
        Assertions.assertFalse((boolean)Thread.interrupted());
    }

    @Test
    void handlingMemberInterruptStillWorksIfExceptionIsIgnored() {
        TimeoutWrappedMessageHandlingMember<Object> mhm = this.createMessageHandlingMember(100, () -> {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
        UnitOfWorkTimeoutInterceptor interceptor = this.createTimeoutInterceptor(500);
        List<EventMessage<?>> batch = this.generateBatch(2);
        BatchingUnitOfWork<?> uow = this.doExecution(batch, interceptor, mhm);
        Awaitility.await().until(() -> uow.isRolledBack());
        Assertions.assertInstanceOf(AxonTimeoutException.class, (Object)uow.getExecutionResult().getExceptionResult());
        Assertions.assertFalse((boolean)Thread.interrupted());
    }

    @Test
    void unitOfWorkInterruptStillWorksIfExceptionIsWrapped() {
        TimeoutWrappedMessageHandlingMember<Object> mhm = this.createMessageHandlingMember(500, () -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Wrapped exception", e);
            }
            return null;
        });
        UnitOfWorkTimeoutInterceptor interceptor = this.createTimeoutInterceptor(300);
        List<EventMessage<?>> batch = this.generateBatch(2);
        BatchingUnitOfWork<?> uow = this.doExecution(batch, interceptor, mhm);
        Awaitility.await().until(() -> uow.isRolledBack());
        Assertions.assertInstanceOf(AxonTimeoutException.class, (Object)uow.getExecutionResult().getExceptionResult());
        Assertions.assertFalse((boolean)Thread.interrupted());
    }

    @Test
    void unitOfWorkInterruptStillWorksIfExceptionIsIgnored() {
        TimeoutWrappedMessageHandlingMember<Object> mhm = this.createMessageHandlingMember(500, () -> {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
        UnitOfWorkTimeoutInterceptor interceptor = this.createTimeoutInterceptor(300);
        List<EventMessage<?>> batch = this.generateBatch(2);
        BatchingUnitOfWork<?> uow = this.doExecution(batch, interceptor, mhm);
        Awaitility.await().until(() -> uow.isRolledBack());
        Assertions.assertInstanceOf(AxonTimeoutException.class, (Object)uow.getExecutionResult().getExceptionResult());
        Assertions.assertFalse((boolean)Thread.interrupted());
    }

    @Test
    void whenThreadIsInterruptedFromUnrelatedProcessTheInterruptIsPreserved() {
        TimeoutWrappedMessageHandlingMember<Object> mhm = this.createMessageHandlingMember(100000, () -> {
            Thread.sleep(20L);
            Thread.currentThread().interrupt();
            return null;
        });
        UnitOfWorkTimeoutInterceptor interceptor = this.createTimeoutInterceptor(100000);
        List<EventMessage<?>> batch = this.generateBatch(2);
        BatchingUnitOfWork<?> uow = this.doExecution(batch, interceptor, mhm);
        Awaitility.await().until(() -> uow.isRolledBack());
        Assertions.assertInstanceOf(InterruptedException.class, (Object)uow.getExecutionResult().getExceptionResult());
        Assertions.assertTrue((boolean)Thread.interrupted());
    }

    private List<EventMessage<?>> generateBatch(int size) {
        LinkedList batch = new LinkedList();
        for (int i = 0; i < size; ++i) {
            batch.add((EventMessage<?>)new GenericEventMessage((Object)("TestEvent" + i)));
        }
        return batch;
    }

    private BatchingUnitOfWork<?> doExecution(List<EventMessage<?>> batch, UnitOfWorkTimeoutInterceptor interceptor, TimeoutWrappedMessageHandlingMember<Object> mhm) {
        BatchingUnitOfWork uow = new BatchingUnitOfWork(batch);
        uow.executeWithResult(() -> interceptor.handle((UnitOfWork)uow, () -> mhm.handle(uow.getMessage(), null)));
        return uow;
    }

    private TimeoutWrappedMessageHandlingMember<Object> createMessageHandlingMember(int timeout, Callable<Object> callable) {
        return new TimeoutWrappedMessageHandlingMember((MessageHandlingMember)new SimpleMessageHandlingMember(callable), timeout, 500, 100);
    }

    private UnitOfWorkTimeoutInterceptor createTimeoutInterceptor(int timeout) {
        return new UnitOfWorkTimeoutInterceptor("TestComponent", timeout, 500, 100, AxonTaskJanitor.INSTANCE, AxonTaskJanitor.LOGGER);
    }

    private static class SimpleMessageHandlingMember
    implements MessageHandlingMember<Object> {
        private final Callable<Object> callable;

        private SimpleMessageHandlingMember(Callable<Object> callable) {
            this.callable = callable;
        }

        public Class<?> payloadType() {
            return String.class;
        }

        public boolean canHandle(@Nonnull Message<?> message) {
            return true;
        }

        public boolean canHandleMessageType(@Nonnull Class<? extends Message> messageType) {
            return true;
        }

        public Object handle(@Nonnull Message<?> message, @Nullable Object target) throws Exception {
            this.callable.call();
            return null;
        }

        public <HT> Optional<HT> unwrap(Class<HT> handlerType) {
            return Optional.empty();
        }

        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return false;
        }

        public Optional<Map<String, Object>> annotationAttributes(Class<? extends Annotation> annotationType) {
            return Optional.empty();
        }
    }
}

