/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import java.lang.reflect.Executable;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.deadline.annotation.DeadlineHandler;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.messaging.annotation.AnnotatedMessageHandlingMemberDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.MessageHandlerTimeout;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.timeout.HandlerTimeoutConfiguration;
import org.axonframework.messaging.timeout.HandlerTimeoutHandlerEnhancerDefinition;
import org.axonframework.messaging.timeout.TaskTimeoutSettings;
import org.axonframework.messaging.timeout.TimeoutWrappedMessageHandlingMember;
import org.axonframework.queryhandling.QueryHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HandlerTimeoutHandlerEnhancerDefinitionTest {
    private AnnotatedMessageHandlingMemberDefinition handlerDefinition;
    private ParameterResolverFactory parameterResolver;
    private HandlerTimeoutHandlerEnhancerDefinition handlerEnhancerDefinition;

    HandlerTimeoutHandlerEnhancerDefinitionTest() {
    }

    @BeforeEach
    void setUp() {
        this.parameterResolver = ClasspathParameterResolverFactory.forClass(this.getClass());
        this.handlerDefinition = new AnnotatedMessageHandlingMemberDefinition();
        this.handlerEnhancerDefinition = new HandlerTimeoutHandlerEnhancerDefinition(new HandlerTimeoutConfiguration(new TaskTimeoutSettings(40000, 34000, 4000), new TaskTimeoutSettings(30000, 24000, 3000), new TaskTimeoutSettings(20000, 14000, 2000), new TaskTimeoutSettings(10000, 4000, 1000)));
    }

    @Test
    void createsCorrectHandlerEnhancerDefinitionForQueryHandlerWithAnnotation() throws NoSuchMethodException {
        MessageHandlingMember<QueryHandlerWithAnnotation> handler = this.getHandler(QueryHandlerWithAnnotation.class, "handle");
        MessageHandlingMember result = this.handlerEnhancerDefinition.wrapHandler(handler);
        this.assertIsWrappedAndAssert(result, 100, 50, 10);
        Assertions.assertInstanceOf(TimeoutWrappedMessageHandlingMember.class, (Object)result);
    }

    @Test
    void createsCorrectHandlerEnhancerDefinitionForQueryHandlerWithoutAnnotation() throws NoSuchMethodException {
        MessageHandlingMember<QueryHandlerWithAnnotation> handler = this.getHandler(QueryHandlerWithAnnotation.class, "handleDefault");
        MessageHandlingMember result = this.handlerEnhancerDefinition.wrapHandler(handler);
        this.assertIsWrappedAndAssert(result, 20000, 14000, 2000);
        Assertions.assertInstanceOf(TimeoutWrappedMessageHandlingMember.class, (Object)result);
    }

    @Test
    void createsCorrectHandlerEnhancerDefinitionForCommandHandlerWithAnnotation() throws NoSuchMethodException {
        MessageHandlingMember<CommandHandlerWithAnnotation> handler = this.getHandler(CommandHandlerWithAnnotation.class, "handle");
        MessageHandlingMember result = this.handlerEnhancerDefinition.wrapHandler(handler);
        this.assertIsWrappedAndAssert(result, 100, 50, 10);
        Assertions.assertInstanceOf(TimeoutWrappedMessageHandlingMember.class, (Object)result);
    }

    @Test
    void createsCorrectHandlerEnhancerDefinitionForCommandHandlerWithoutAnnotation() throws NoSuchMethodException {
        MessageHandlingMember<CommandHandlerWithAnnotation> handler = this.getHandler(CommandHandlerWithAnnotation.class, "handleDefault");
        MessageHandlingMember result = this.handlerEnhancerDefinition.wrapHandler(handler);
        this.assertIsWrappedAndAssert(result, 30000, 24000, 3000);
        Assertions.assertInstanceOf(TimeoutWrappedMessageHandlingMember.class, (Object)result);
    }

    @Test
    void createsCorrectHandlerEnhancerDefinitionForEventHandlerWithAnnotation() throws NoSuchMethodException {
        MessageHandlingMember<EventHandlerWithAnnotation> handler = this.getHandler(EventHandlerWithAnnotation.class, "handle");
        MessageHandlingMember result = this.handlerEnhancerDefinition.wrapHandler(handler);
        this.assertIsWrappedAndAssert(result, 100, 50, 10);
        Assertions.assertInstanceOf(TimeoutWrappedMessageHandlingMember.class, (Object)result);
    }

    @Test
    void createsCorrectHandlerEnhancerDefinitionForEventHandlerWithoutAnnotation() throws NoSuchMethodException {
        MessageHandlingMember<EventHandlerWithAnnotation> handler = this.getHandler(EventHandlerWithAnnotation.class, "handleDefault");
        MessageHandlingMember result = this.handlerEnhancerDefinition.wrapHandler(handler);
        this.assertIsWrappedAndAssert(result, 40000, 34000, 4000);
        Assertions.assertInstanceOf(TimeoutWrappedMessageHandlingMember.class, (Object)result);
    }

    @Test
    void createsCorrectHandlerEnhancerDefinitionForDeadlineHandlerWithAnnotation() throws NoSuchMethodException {
        MessageHandlingMember<DeadlineHandlerWithAnnotation> handler = this.getHandler(DeadlineHandlerWithAnnotation.class, "handle");
        MessageHandlingMember result = this.handlerEnhancerDefinition.wrapHandler(handler);
        this.assertIsWrappedAndAssert(result, 100, 50, 10);
        Assertions.assertInstanceOf(TimeoutWrappedMessageHandlingMember.class, (Object)result);
    }

    @Test
    void createsCorrectHandlerEnhancerDefinitionForDeadlineHandlerWithoutAnnotation() throws NoSuchMethodException {
        MessageHandlingMember<DeadlineHandlerWithAnnotation> handler = this.getHandler(DeadlineHandlerWithAnnotation.class, "handleDefault");
        MessageHandlingMember result = this.handlerEnhancerDefinition.wrapHandler(handler);
        this.assertIsWrappedAndAssert(result, 10000, 4000, 1000);
        Assertions.assertInstanceOf(TimeoutWrappedMessageHandlingMember.class, (Object)result);
    }

    private void assertIsWrappedAndAssert(MessageHandlingMember<?> handler, int timeout, int warningThreshold, int warningInterval) {
        Assertions.assertInstanceOf(TimeoutWrappedMessageHandlingMember.class, handler);
        TimeoutWrappedMessageHandlingMember castResult = (TimeoutWrappedMessageHandlingMember)handler;
        Assertions.assertEquals((int)timeout, (int)castResult.getTimeout());
        Assertions.assertEquals((int)warningThreshold, (int)castResult.getWarningThreshold());
        Assertions.assertEquals((int)warningInterval, (int)castResult.getWarningInterval());
    }

    private <T> MessageHandlingMember<T> getHandler(Class<T> targetClass, String methodName) throws NoSuchMethodException {
        return (MessageHandlingMember)this.handlerDefinition.createHandler(targetClass, (Executable)targetClass.getDeclaredMethod(methodName, String.class), this.parameterResolver).get();
    }

    public static class DeadlineHandlerWithAnnotation {
        @MessageHandlerTimeout(timeoutMs=100, warningThresholdMs=50, warningIntervalMs=10)
        @DeadlineHandler
        public void handle(String message) {
        }

        @DeadlineHandler
        public void handleDefault(String message) {
        }
    }

    public static class CommandHandlerWithAnnotation {
        @MessageHandlerTimeout(timeoutMs=100, warningThresholdMs=50, warningIntervalMs=10)
        @CommandHandler
        public void handle(String message) {
        }

        @CommandHandler
        public void handleDefault(String message) {
        }
    }

    public static class EventHandlerWithAnnotation {
        @MessageHandlerTimeout(timeoutMs=100, warningThresholdMs=50, warningIntervalMs=10)
        @EventHandler
        public void handle(String message) {
        }

        @EventHandler
        public void handleDefault(String message) {
        }
    }

    public static class QueryHandlerWithAnnotation {
        @MessageHandlerTimeout(timeoutMs=100, warningThresholdMs=50, warningIntervalMs=10)
        @QueryHandler
        public void handle(String message) {
        }

        @QueryHandler
        public void handleDefault(String message) {
        }
    }
}

