/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import java.lang.reflect.Executable;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedMessageHandlingMemberDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.timeout.AxonTimeoutException;
import org.axonframework.messaging.timeout.TimeoutWrappedMessageHandlingMember;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TimeoutWrappedMessageHandlingMemberTest {
    private AnnotatedMessageHandlingMemberDefinition handlerDefinition;
    private ParameterResolverFactory parameterResolver;

    TimeoutWrappedMessageHandlingMemberTest() {
    }

    @BeforeEach
    void setUp() {
        this.parameterResolver = ClasspathParameterResolverFactory.forClass(this.getClass());
        this.handlerDefinition = new AnnotatedMessageHandlingMemberDefinition();
    }

    @Test
    void interruptsMessageHandlingMemberAsConfigured() throws NoSuchMethodException {
        MessageHandlingMember original = (MessageHandlingMember)this.handlerDefinition.createHandler(TestMessageHandler.class, (Executable)TestMessageHandler.class.getDeclaredMethod("handle", String.class), this.parameterResolver).get();
        TimeoutWrappedMessageHandlingMember wrappedHandler = new TimeoutWrappedMessageHandlingMember(original, 300, 200, 50);
        Assertions.assertThrows(AxonTimeoutException.class, () -> wrappedHandler.handle((Message)GenericEventMessage.asEventMessage((Object)"my-message"), (Object)new TestMessageHandler()));
    }

    public static class TestMessageHandler {
        @EventHandler
        public void handle(String message) throws InterruptedException {
            Thread.sleep(500L);
        }
    }
}

