/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import java.util.Collections;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.timeout.AxonTimeoutException;
import org.axonframework.messaging.timeout.UnitOfWorkTimeoutInterceptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UnitOfWorkTimeoutInterceptorTest {
    UnitOfWorkTimeoutInterceptorTest() {
    }

    @Test
    void interruptsUnitOfWorkThatTakesTooLong() throws Exception {
        UnitOfWorkTimeoutInterceptor testSubject = new UnitOfWorkTimeoutInterceptor("MyUnitOfWork", 100, 50, 10);
        DefaultUnitOfWork uow = new DefaultUnitOfWork((Message)GenericEventMessage.asEventMessage((Object)"test"));
        DefaultInterceptorChain interceptorChain = new DefaultInterceptorChain((UnitOfWork)uow, Collections.singletonList(testSubject), message -> {
            Thread.sleep(300L);
            return null;
        });
        uow.executeWithResult(() -> ((DefaultInterceptorChain)interceptorChain).proceed());
        Assertions.assertTrue((boolean)uow.isRolledBack());
        Assertions.assertTrue((boolean)uow.getExecutionResult().isExceptionResult());
        Assertions.assertInstanceOf(AxonTimeoutException.class, (Object)uow.getExecutionResult().getExceptionResult());
    }

    @Test
    void doesNotInterruptWorkWithinTime() throws Exception {
        UnitOfWorkTimeoutInterceptor testSubject = new UnitOfWorkTimeoutInterceptor("MyUnitOfWork", 100, 50, 10);
        DefaultUnitOfWork uow = new DefaultUnitOfWork((Message)GenericEventMessage.asEventMessage((Object)"test"));
        DefaultInterceptorChain interceptorChain = new DefaultInterceptorChain((UnitOfWork)uow, Collections.singletonList(testSubject), message -> {
            Thread.sleep(80L);
            return null;
        });
        uow.executeWithResult(() -> ((DefaultInterceptorChain)interceptorChain).proceed());
        Assertions.assertFalse((boolean)uow.isRolledBack());
        Assertions.assertFalse((boolean)uow.getExecutionResult().isExceptionResult());
    }
}

