/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CurrentUnitOfWorkTest {
    CurrentUnitOfWorkTest() {
    }

    @BeforeEach
    void setUp() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @AfterEach
    void tearDown() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @Test
    void getSession_NoCurrentSession() {
        Assertions.assertThrows(IllegalStateException.class, CurrentUnitOfWork::get);
    }

    @Test
    void setSession() {
        UnitOfWork mockUnitOfWork = (UnitOfWork)Mockito.mock(UnitOfWork.class);
        CurrentUnitOfWork.set((UnitOfWork)mockUnitOfWork);
        Assertions.assertSame((Object)mockUnitOfWork, (Object)CurrentUnitOfWork.get());
        CurrentUnitOfWork.clear((UnitOfWork)mockUnitOfWork);
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted());
    }

    @Test
    void notCurrentUnitOfWorkCommitted() {
        DefaultUnitOfWork outerUoW = new DefaultUnitOfWork(null);
        outerUoW.start();
        new DefaultUnitOfWork(null).start();
        try {
            outerUoW.commit();
        }
        catch (IllegalStateException e) {
            return;
        }
        throw new AssertionError((Object)"The unit of work is not the current");
    }
}

