/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import org.axonframework.messaging.GenericResultMessage;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ExecutionResultTest {
    ExecutionResultTest() {
    }

    @Test
    void normalExecutionResult() {
        Object resultPayload = new Object();
        ResultMessage result = GenericResultMessage.asResultMessage((Object)resultPayload);
        ExecutionResult subject = new ExecutionResult(result);
        Assertions.assertSame((Object)result, (Object)subject.getResult());
        Assertions.assertFalse((boolean)subject.isExceptionResult());
        Assertions.assertNull((Object)subject.getExceptionResult());
    }

    @Test
    void uncheckedExceptionResult() {
        RuntimeException mockException = new RuntimeException();
        ResultMessage resultMessage = GenericResultMessage.asResultMessage((Throwable)mockException);
        ExecutionResult subject = new ExecutionResult(resultMessage);
        Assertions.assertTrue((boolean)subject.isExceptionResult());
        Assertions.assertSame((Object)mockException, (Object)subject.getExceptionResult());
        Assertions.assertSame((Object)mockException, (Object)subject.getResult().exceptionResult());
    }

    @Test
    void checkedExceptionResult() {
        Exception mockException = new Exception();
        ResultMessage resultMessage = GenericResultMessage.asResultMessage((Throwable)mockException);
        ExecutionResult subject = new ExecutionResult(resultMessage);
        Assertions.assertTrue((boolean)subject.isExceptionResult());
        Assertions.assertSame((Object)mockException, (Object)subject.getExceptionResult());
        Assertions.assertSame((Object)mockException, (Object)subject.getResult().exceptionResult());
    }
}

