/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UnitOfWorkNestingTest {
    private List<PhaseTransition> phaseTransitions = new ArrayList<PhaseTransition>();
    private UnitOfWork<?> outer;
    private UnitOfWork<?> middle;
    private UnitOfWork<?> inner;

    UnitOfWorkNestingTest() {
    }

    @BeforeEach
    void setUp() {
        this.phaseTransitions.clear();
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
        this.outer = new DefaultUnitOfWork((Message)new GenericEventMessage((Object)"Input 1")){

            public String toString() {
                return "outer";
            }
        };
        this.middle = new DefaultUnitOfWork((Message)new GenericEventMessage((Object)"Input middle")){

            public String toString() {
                return "middle";
            }
        };
        this.inner = new DefaultUnitOfWork((Message)new GenericEventMessage((Object)"Input 2")){

            public String toString() {
                return "inner";
            }
        };
        this.registerListeners(this.outer);
        this.registerListeners(this.middle);
        this.registerListeners(this.inner);
    }

    private void registerListeners(UnitOfWork<?> unitOfWork) {
        unitOfWork.onPrepareCommit(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.PREPARE_COMMIT)));
        unitOfWork.onCommit(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.COMMIT)));
        unitOfWork.afterCommit(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.AFTER_COMMIT)));
        unitOfWork.onRollback(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.ROLLBACK)));
        unitOfWork.onCleanup(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.CLEANUP)));
    }

    @AfterEach
    void tearDown() {
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted(), (String)"A UnitOfWork was not properly cleared");
    }

    @Test
    void innerUnitOfWorkNotifiedOfOuterCommitFailure() {
        this.outer.onPrepareCommit(u -> {
            this.inner.start();
            this.inner.commit();
        });
        this.outer.onCommit(u -> {
            throw new MockException();
        });
        this.outer.onCommit(u -> this.phaseTransitions.add(new PhaseTransition((UnitOfWork<?>)u, UnitOfWork.Phase.COMMIT, "x")));
        this.outer.start();
        try {
            this.outer.commit();
        }
        catch (MockException mockException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted(), (String)"The UnitOfWork hasn't been correctly cleared");
        Assertions.assertEquals(Arrays.asList(new PhaseTransition(this.outer, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.COMMIT), new PhaseTransition(this.outer, UnitOfWork.Phase.COMMIT, "x"), new PhaseTransition(this.inner, UnitOfWork.Phase.ROLLBACK), new PhaseTransition(this.outer, UnitOfWork.Phase.ROLLBACK), new PhaseTransition(this.inner, UnitOfWork.Phase.CLEANUP), new PhaseTransition(this.outer, UnitOfWork.Phase.CLEANUP)), this.phaseTransitions);
    }

    @Test
    void innerUnitOfWorkNotifiedOfOuterPrepareCommitFailure() {
        this.outer.onPrepareCommit(u -> {
            this.inner.start();
            this.inner.commit();
        });
        this.outer.onPrepareCommit(u -> {
            throw new MockException();
        });
        this.outer.start();
        try {
            this.outer.commit();
        }
        catch (MockException mockException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted(), (String)"The UnitOfWork hasn't been correctly cleared");
        Assertions.assertEquals(Arrays.asList(new PhaseTransition(this.outer, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.ROLLBACK), new PhaseTransition(this.outer, UnitOfWork.Phase.ROLLBACK), new PhaseTransition(this.inner, UnitOfWork.Phase.CLEANUP), new PhaseTransition(this.outer, UnitOfWork.Phase.CLEANUP)), this.phaseTransitions);
    }

    @Test
    void innerUnitOfWorkNotifiedOfOuterCommit() {
        this.outer.onPrepareCommit(u -> {
            this.inner.start();
            this.inner.commit();
        });
        this.outer.start();
        this.outer.commit();
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted(), (String)"The UnitOfWork hasn't been correctly cleared");
        Assertions.assertEquals(Arrays.asList(new PhaseTransition(this.outer, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.COMMIT), new PhaseTransition(this.outer, UnitOfWork.Phase.COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.AFTER_COMMIT), new PhaseTransition(this.outer, UnitOfWork.Phase.AFTER_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.CLEANUP), new PhaseTransition(this.outer, UnitOfWork.Phase.CLEANUP)), this.phaseTransitions);
    }

    @Test
    void innerUnitRollbackDoesNotAffectOuterCommit() {
        this.outer.onPrepareCommit(u -> {
            this.inner.start();
            this.inner.rollback((Throwable)new MockException());
        });
        this.outer.start();
        this.outer.commit();
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted(), (String)"The UnitOfWork hasn't been correctly cleared");
        Assertions.assertEquals(Arrays.asList(new PhaseTransition(this.outer, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.ROLLBACK), new PhaseTransition(this.outer, UnitOfWork.Phase.COMMIT), new PhaseTransition(this.outer, UnitOfWork.Phase.AFTER_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.CLEANUP), new PhaseTransition(this.outer, UnitOfWork.Phase.CLEANUP)), this.phaseTransitions);
    }

    @Test
    void rollbackOfMiddleUnitOfWorkRollsBackInner() {
        this.outer.onPrepareCommit(u -> {
            this.middle.start();
            this.inner.start();
            this.inner.commit();
            this.middle.rollback();
        });
        this.outer.start();
        this.outer.commit();
        Assertions.assertTrue((boolean)this.middle.isRolledBack(), (String)"The middle UnitOfWork hasn't been correctly marked as rolled back");
        Assertions.assertTrue((boolean)this.inner.isRolledBack(), (String)"The inner UnitOfWork hasn't been correctly marked as rolled back");
        Assertions.assertFalse((boolean)this.outer.isRolledBack(), (String)"The out UnitOfWork has been incorrectly marked as rolled back");
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted(), (String)"The UnitOfWork hasn't been correctly cleared");
        Assertions.assertEquals(Arrays.asList(new PhaseTransition(this.outer, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.ROLLBACK), new PhaseTransition(this.middle, UnitOfWork.Phase.ROLLBACK), new PhaseTransition(this.outer, UnitOfWork.Phase.COMMIT), new PhaseTransition(this.outer, UnitOfWork.Phase.AFTER_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.CLEANUP), new PhaseTransition(this.middle, UnitOfWork.Phase.CLEANUP), new PhaseTransition(this.outer, UnitOfWork.Phase.CLEANUP)), this.phaseTransitions);
    }

    @Test
    void innerUnitCommitFailureDoesNotAffectOuterCommit() {
        this.outer.onPrepareCommit(u -> {
            this.inner.start();
            this.inner.onCommit(uow -> {
                throw new MockException();
            });
            this.inner.onCommit(uow -> this.phaseTransitions.add(new PhaseTransition(this.inner, UnitOfWork.Phase.COMMIT, "x")));
            try {
                this.inner.commit();
            }
            catch (MockException mockException) {
                // empty catch block
            }
        });
        this.outer.start();
        this.outer.commit();
        Assertions.assertFalse((boolean)CurrentUnitOfWork.isStarted(), (String)"The UnitOfWork hasn't been correctly cleared");
        Assertions.assertEquals(Arrays.asList(new PhaseTransition(this.outer, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.PREPARE_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.COMMIT, "x"), new PhaseTransition(this.inner, UnitOfWork.Phase.ROLLBACK), new PhaseTransition(this.outer, UnitOfWork.Phase.COMMIT), new PhaseTransition(this.outer, UnitOfWork.Phase.AFTER_COMMIT), new PhaseTransition(this.inner, UnitOfWork.Phase.CLEANUP), new PhaseTransition(this.outer, UnitOfWork.Phase.CLEANUP)), this.phaseTransitions);
    }

    private static class PhaseTransition {
        private final UnitOfWork.Phase phase;
        private final UnitOfWork<?> unitOfWork;
        private final String id;

        public PhaseTransition(UnitOfWork<?> unitOfWork, UnitOfWork.Phase phase) {
            this(unitOfWork, phase, "");
        }

        public PhaseTransition(UnitOfWork<?> unitOfWork, UnitOfWork.Phase phase, String id) {
            this.unitOfWork = unitOfWork;
            this.phase = phase;
            this.id = id.length() > 0 ? " " + id : id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhaseTransition that = (PhaseTransition)o;
            return Objects.equals(this.phase, that.phase) && Objects.equals(this.unitOfWork, that.unitOfWork) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.phase, this.unitOfWork, this.id);
        }

        public String toString() {
            return this.unitOfWork + " " + this.phase + this.id;
        }
    }
}

