/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.monitoring;

import java.util.Arrays;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.MultiMessageMonitor;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class MultiMessageMonitorTest {
    MultiMessageMonitorTest() {
    }

    @Test
    void onMessageIngested_SingleMessageMonitor_failure() {
        MessageMonitor messageMonitorMock = (MessageMonitor)Mockito.mock(MessageMonitor.class);
        MessageMonitor.MonitorCallback callback = (MessageMonitor.MonitorCallback)Mockito.mock(MessageMonitor.MonitorCallback.class);
        MultiMessageMonitor multiMessageMonitor = new MultiMessageMonitor(Arrays.asList(messageMonitorMock));
        Message messageMock = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)messageMonitorMock.onMessageIngested(messageMock)).thenReturn((Object)callback);
        MessageMonitor.MonitorCallback monitorCallback = multiMessageMonitor.onMessageIngested(messageMock);
        Throwable throwable = new Throwable();
        monitorCallback.reportFailure(throwable);
        ((MessageMonitor)Mockito.verify((Object)messageMonitorMock)).onMessageIngested((Message)ArgumentMatchers.same((Object)messageMock));
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)callback)).reportFailure((Throwable)ArgumentMatchers.same((Object)throwable));
    }

    @Test
    void onMessageIngested_SingleMessageMonitor_success() {
        MessageMonitor messageMonitorMock = (MessageMonitor)Mockito.mock(MessageMonitor.class);
        MessageMonitor.MonitorCallback callback = (MessageMonitor.MonitorCallback)Mockito.mock(MessageMonitor.MonitorCallback.class);
        MultiMessageMonitor multiMessageMonitor = new MultiMessageMonitor(Arrays.asList(messageMonitorMock));
        Message messageMock = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)messageMonitorMock.onMessageIngested(messageMock)).thenReturn((Object)callback);
        MessageMonitor.MonitorCallback monitorCallback = multiMessageMonitor.onMessageIngested(messageMock);
        monitorCallback.reportSuccess();
        ((MessageMonitor)Mockito.verify((Object)messageMonitorMock)).onMessageIngested((Message)ArgumentMatchers.same((Object)messageMock));
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)callback)).reportSuccess();
    }

    @Test
    void onMessageIngested_MultipleMessageMonitors() {
        MessageMonitor messageMonitorMock1 = (MessageMonitor)Mockito.mock(MessageMonitor.class);
        MessageMonitor.MonitorCallback callback1 = (MessageMonitor.MonitorCallback)Mockito.mock(MessageMonitor.MonitorCallback.class);
        MessageMonitor messageMonitorMock2 = (MessageMonitor)Mockito.mock(MessageMonitor.class);
        MessageMonitor.MonitorCallback callback2 = (MessageMonitor.MonitorCallback)Mockito.mock(MessageMonitor.MonitorCallback.class);
        MultiMessageMonitor multiMessageMonitor = new MultiMessageMonitor(Arrays.asList(messageMonitorMock1, messageMonitorMock2));
        Message messageMock = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)messageMonitorMock1.onMessageIngested(messageMock)).thenReturn((Object)callback1);
        Mockito.when((Object)messageMonitorMock2.onMessageIngested(messageMock)).thenReturn((Object)callback2);
        multiMessageMonitor.onMessageIngested(messageMock).reportSuccess();
        ((MessageMonitor)Mockito.verify((Object)messageMonitorMock1)).onMessageIngested((Message)ArgumentMatchers.same((Object)messageMock));
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)callback1)).reportSuccess();
        ((MessageMonitor)Mockito.verify((Object)messageMonitorMock2)).onMessageIngested((Message)ArgumentMatchers.same((Object)messageMock));
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)callback2)).reportSuccess();
    }
}

