/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.DefaultQueryBusSpanFactory;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.tracing.IntermediateSpanFactoryTest;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultQueryBusSpanFactoryTest
extends IntermediateSpanFactoryTest<DefaultQueryBusSpanFactory.Builder, DefaultQueryBusSpanFactory> {
    DefaultQueryBusSpanFactoryTest() {
    }

    @Test
    void createsQuerySpanNonDistributed() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.test(spanFactory -> spanFactory.createQuerySpan(queryMessage, false), this.expectedSpan("QueryBus.query", TestSpanFactory.TestSpanType.INTERNAL).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsQuerySpanDistributed() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.test(spanFactory -> spanFactory.createQuerySpan(queryMessage, true), this.expectedSpan("QueryBus.queryDistributed", TestSpanFactory.TestSpanType.DISPATCH).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsSubscriptionQuerySpanNonDistributed() {
        SubscriptionQueryMessage queryMessage = (SubscriptionQueryMessage)Mockito.mock(SubscriptionQueryMessage.class);
        this.test(spanFactory -> spanFactory.createSubscriptionQuerySpan(queryMessage, false), this.expectedSpan("QueryBus.subscriptionQuery", TestSpanFactory.TestSpanType.INTERNAL).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsSubscriptionQuerySpanDistributed() {
        SubscriptionQueryMessage queryMessage = (SubscriptionQueryMessage)Mockito.mock(SubscriptionQueryMessage.class);
        this.test(spanFactory -> spanFactory.createSubscriptionQuerySpan(queryMessage, true), this.expectedSpan("QueryBus.subscriptionQueryDistributed", TestSpanFactory.TestSpanType.DISPATCH).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsScatterGatherQuerySpanNonDistributed() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.test(spanFactory -> spanFactory.createScatterGatherSpan(queryMessage, false), this.expectedSpan("QueryBus.scatterGatherQuery", TestSpanFactory.TestSpanType.INTERNAL).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsScatterGatherQuerySpanDistributed() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.test(spanFactory -> spanFactory.createScatterGatherSpan(queryMessage, true), this.expectedSpan("QueryBus.scatterGatherQueryDistributed", TestSpanFactory.TestSpanType.DISPATCH).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsScatterGatherHandlerSpan() {
        SubscriptionQueryMessage queryMessage = (SubscriptionQueryMessage)Mockito.mock(SubscriptionQueryMessage.class);
        this.test(spanFactory -> spanFactory.createScatterGatherHandlerSpan((QueryMessage)queryMessage, 4), this.expectedSpan("QueryBus.scatterGatherHandler-4", TestSpanFactory.TestSpanType.INTERNAL).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsStreamingQuerySpanNonDistributed() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.test(spanFactory -> spanFactory.createStreamingQuerySpan(queryMessage, false), this.expectedSpan("QueryBus.streamingQuery", TestSpanFactory.TestSpanType.HANDLER_CHILD).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsStreamingQuerySpanDistributed() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.test(spanFactory -> spanFactory.createStreamingQuerySpan(queryMessage, true), this.expectedSpan("QueryBus.streamingQueryDistributed", TestSpanFactory.TestSpanType.DISPATCH).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsQueryProcessingSpanDistributed() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.test(builder -> builder.distributedInSameTrace(true), spanFactory -> spanFactory.createQueryProcessingSpan(queryMessage), this.expectedSpan("QueryBus.processQueryMessage", TestSpanFactory.TestSpanType.HANDLER_CHILD).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsQueryProcessingSpanDistributedButSeparateTrace() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.test(builder -> builder.distributedInSameTrace(false), spanFactory -> spanFactory.createQueryProcessingSpan(queryMessage), this.expectedSpan("QueryBus.processQueryMessage", TestSpanFactory.TestSpanType.HANDLER_LINK).withMessage((Message<?>)queryMessage));
    }

    @Test
    void createsResponseProcessingSpan() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.test(spanFactory -> spanFactory.createResponseProcessingSpan(queryMessage), this.expectedSpan("QueryBus.processQueryResponse", TestSpanFactory.TestSpanType.INTERNAL).withMessage((Message<?>)queryMessage));
    }

    @Test
    void propagateContext() {
        QueryMessage queryMessage = (QueryMessage)Mockito.mock(QueryMessage.class);
        this.testContextPropagation(queryMessage, DefaultQueryBusSpanFactory::propagateContext);
    }

    @Override
    protected DefaultQueryBusSpanFactory.Builder createBuilder(SpanFactory spanFactory) {
        return DefaultQueryBusSpanFactory.builder().spanFactory(spanFactory);
    }

    @Override
    protected DefaultQueryBusSpanFactory createFactoryBasedOnBuilder(DefaultQueryBusSpanFactory.Builder builder) {
        return builder.build();
    }
}

