/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.DefaultQueryUpdateEmitterSpanFactory;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.tracing.IntermediateSpanFactoryTest;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultQueryUpdateEmitterSpanFactoryTest
extends IntermediateSpanFactoryTest<DefaultQueryUpdateEmitterSpanFactory.Builder, DefaultQueryUpdateEmitterSpanFactory> {
    DefaultQueryUpdateEmitterSpanFactoryTest() {
    }

    @Test
    void createsDefaultScheduleSpan() {
        SubscriptionQueryUpdateMessage message = (SubscriptionQueryUpdateMessage)Mockito.mock(SubscriptionQueryUpdateMessage.class);
        this.test(spanFactory -> spanFactory.createUpdateScheduleEmitSpan(message), this.expectedSpan("QueryUpdateEmitter.scheduleQueryUpdateMessage", TestSpanFactory.TestSpanType.INTERNAL).withMessage((Message<?>)message));
    }

    @Test
    void createsDefaultEmitSpan() {
        SubscriptionQueryUpdateMessage message = (SubscriptionQueryUpdateMessage)Mockito.mock(SubscriptionQueryUpdateMessage.class);
        this.test(spanFactory -> spanFactory.createUpdateEmitSpan(message), this.expectedSpan("QueryUpdateEmitter.emitQueryUpdateMessage", TestSpanFactory.TestSpanType.DISPATCH).withMessage((Message<?>)message));
    }

    @Test
    void propagateContext() {
        SubscriptionQueryUpdateMessage message = (SubscriptionQueryUpdateMessage)Mockito.mock(SubscriptionQueryUpdateMessage.class);
        this.testContextPropagation(message, DefaultQueryUpdateEmitterSpanFactory::propagateContext);
    }

    @Override
    protected DefaultQueryUpdateEmitterSpanFactory.Builder createBuilder(SpanFactory spanFactory) {
        return DefaultQueryUpdateEmitterSpanFactory.builder().spanFactory(spanFactory);
    }

    @Override
    protected DefaultQueryUpdateEmitterSpanFactory createFactoryBasedOnBuilder(DefaultQueryUpdateEmitterSpanFactory.Builder builder) {
        return builder.build();
    }
}

