/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.queryhandling.DefaultSubscriptionQueryResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultSubscriptionQueryResultTest {
    DefaultSubscriptionQueryResultTest() {
    }

    @Test
    void handleInvokesErrorConsumerOnExceptionInTheInitialResult() {
        AtomicBoolean canceled = new AtomicBoolean(false);
        AtomicBoolean initialResultConsumed = new AtomicBoolean(false);
        AtomicBoolean updateConsumed = new AtomicBoolean(false);
        AtomicBoolean errorConsumed = new AtomicBoolean(false);
        DefaultSubscriptionQueryResult testSubject = new DefaultSubscriptionQueryResult(Mono.error((Throwable)new RuntimeException("oops")), Flux.empty(), () -> {
            canceled.set(true);
            return true;
        });
        testSubject.handle(initialResult -> initialResultConsumed.set(true), update -> updateConsumed.set(true), error -> errorConsumed.set(true));
        Assertions.assertTrue((boolean)canceled.get());
        Assertions.assertFalse((boolean)initialResultConsumed.get());
        Assertions.assertFalse((boolean)updateConsumed.get());
        Assertions.assertTrue((boolean)errorConsumed.get());
    }

    @Test
    void handleInvokesErrorConsumerOnExceptionsInTheUpdates() {
        AtomicBoolean canceled = new AtomicBoolean(false);
        AtomicBoolean initialResultConsumed = new AtomicBoolean(false);
        AtomicBoolean updateConsumed = new AtomicBoolean(false);
        AtomicBoolean errorConsumed = new AtomicBoolean(false);
        DefaultSubscriptionQueryResult testSubject = new DefaultSubscriptionQueryResult(Mono.just((Object)"some-initial-result"), Flux.error((Throwable)new RuntimeException("oops")), () -> {
            canceled.set(true);
            return true;
        });
        testSubject.handle(initialResult -> initialResultConsumed.set(true), update -> updateConsumed.set(true), error -> errorConsumed.set(true));
        Assertions.assertTrue((boolean)canceled.get());
        Assertions.assertTrue((boolean)initialResultConsumed.get());
        Assertions.assertFalse((boolean)updateConsumed.get());
        Assertions.assertTrue((boolean)errorConsumed.get());
    }

    @Test
    void handleInvokesErrorConsumerOnExceptionThrownByTheInitialResultConsumer() {
        AtomicBoolean canceled = new AtomicBoolean(false);
        AtomicBoolean updateConsumed = new AtomicBoolean(false);
        AtomicBoolean errorConsumed = new AtomicBoolean(false);
        DefaultSubscriptionQueryResult testSubject = new DefaultSubscriptionQueryResult(Mono.just((Object)"some-initial-result"), Flux.just((Object)"some-update"), () -> {
            canceled.set(true);
            return true;
        });
        testSubject.handle(initialResult -> {
            throw new RuntimeException("oops");
        }, update -> updateConsumed.set(true), error -> errorConsumed.set(true));
        Assertions.assertTrue((boolean)canceled.get());
        Assertions.assertFalse((boolean)updateConsumed.get());
        Assertions.assertTrue((boolean)errorConsumed.get());
    }

    @Test
    void handleInvokesErrorConsumerOnExceptionThrownByTheUpdateConsumer() {
        AtomicBoolean canceled = new AtomicBoolean(false);
        AtomicBoolean initialResultConsumed = new AtomicBoolean(false);
        AtomicBoolean errorConsumed = new AtomicBoolean(false);
        DefaultSubscriptionQueryResult testSubject = new DefaultSubscriptionQueryResult(Mono.just((Object)"some-initial-result"), Flux.just((Object)"some-update"), () -> {
            canceled.set(true);
            return true;
        });
        testSubject.handle(initialResult -> initialResultConsumed.set(true), update -> {
            throw new RuntimeException("oops");
        }, error -> errorConsumed.set(true));
        Assertions.assertTrue((boolean)canceled.get());
        Assertions.assertTrue((boolean)initialResultConsumed.get());
        Assertions.assertTrue((boolean)errorConsumed.get());
    }
}

