/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.annotation.AnnotationQueryHandlerAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

class FutureAsResponseTypeToQueryHandlersTest {
    private static final int FUTURE_RESOLVING_TIMEOUT = 500;
    private final SimpleQueryBus queryBus = SimpleQueryBus.builder().build();
    private final MyQueryHandler myQueryHandler = new MyQueryHandler();
    private final AnnotationQueryHandlerAdapter<MyQueryHandler> annotationQueryHandlerAdapter = new AnnotationQueryHandlerAdapter((Object)this.myQueryHandler);

    FutureAsResponseTypeToQueryHandlersTest() {
    }

    @BeforeEach
    void setUp() {
        this.annotationQueryHandlerAdapter.subscribe((QueryBus)this.queryBus);
    }

    @Test
    void queryWithMultipleResponses() throws ExecutionException, InterruptedException {
        GenericQueryMessage queryMessage = new GenericQueryMessage((Object)"criteria", "myQueryWithMultipleResponses", ResponseTypes.multipleInstancesOf(String.class));
        List response = (List)((QueryResponseMessage)this.queryBus.query((QueryMessage)queryMessage).get()).getPayload();
        Assertions.assertEquals(Arrays.asList("Response1", "Response2"), (Object)response);
    }

    @Test
    void queryWithSingleResponse() throws ExecutionException, InterruptedException {
        GenericQueryMessage queryMessage = new GenericQueryMessage((Object)"criteria", "myQueryWithSingleResponse", ResponseTypes.instanceOf(String.class));
        String response = (String)((QueryResponseMessage)this.queryBus.query((QueryMessage)queryMessage).get()).getPayload();
        Assertions.assertEquals((Object)"Response", (Object)response);
    }

    @Test
    void scatterGatherQueryWithMultipleResponses() {
        GenericQueryMessage queryMessage = new GenericQueryMessage((Object)"criteria", "myQueryWithMultipleResponses", ResponseTypes.multipleInstancesOf(String.class));
        List response = this.queryBus.scatterGather((QueryMessage)queryMessage, 1000L, TimeUnit.MILLISECONDS).map(Message::getPayload).flatMap(Collection::stream).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList("Response1", "Response2"), response);
    }

    @Test
    void scatterGatherQueryWithSingleResponse() {
        GenericQueryMessage queryMessage = new GenericQueryMessage((Object)"criteria", "myQueryWithSingleResponse", ResponseTypes.instanceOf(String.class));
        String response = this.queryBus.scatterGather((QueryMessage)queryMessage, 600L, TimeUnit.MILLISECONDS).map(Message::getPayload).findFirst().orElse(null);
        Assertions.assertEquals((Object)"Response", (Object)response);
    }

    @Test
    void subscriptionQueryWithMultipleResponses() {
        GenericSubscriptionQueryMessage queryMessage = new GenericSubscriptionQueryMessage((Object)"criteria", "myQueryWithMultipleResponses", ResponseTypes.multipleInstancesOf(String.class), ResponseTypes.instanceOf(String.class));
        Mono response = this.queryBus.subscriptionQuery((SubscriptionQueryMessage)queryMessage).initialResult().map(Message::getPayload);
        StepVerifier.create((Publisher)response).expectNext(Arrays.asList("Response1", "Response2")).verifyComplete();
    }

    @Test
    void subscriptionQueryWithSingleResponse() {
        GenericSubscriptionQueryMessage queryMessage = new GenericSubscriptionQueryMessage((Object)"criteria", "myQueryWithSingleResponse", ResponseTypes.instanceOf(String.class), ResponseTypes.instanceOf(String.class));
        Mono response = this.queryBus.subscriptionQuery((SubscriptionQueryMessage)queryMessage).initialResult().map(Message::getPayload);
        StepVerifier.create((Publisher)response).expectNext((Object)"Response").verifyComplete();
    }

    @Test
    void futureQueryWithMultipleResponses() throws ExecutionException, InterruptedException {
        GenericQueryMessage queryMessage = new GenericQueryMessage((Object)"criteria", "myQueryFutureWithMultipleResponses", ResponseTypes.multipleInstancesOf(String.class));
        List result = (List)((QueryResponseMessage)this.queryBus.query((QueryMessage)queryMessage).get()).getPayload();
        Assertions.assertEquals(Arrays.asList("Response1", "Response2"), (Object)result);
    }

    @Test
    void futureScatterGatherQueryWithMultipleResponses() {
        GenericQueryMessage queryMessage = new GenericQueryMessage((Object)"criteria", "myQueryFutureWithMultipleResponses", ResponseTypes.multipleInstancesOf(String.class));
        List result = this.queryBus.scatterGather((QueryMessage)queryMessage, 600L, TimeUnit.MILLISECONDS).map(Message::getPayload).findFirst().orElse(null);
        Assertions.assertEquals(Arrays.asList("Response1", "Response2"), (Object)result);
    }

    @Test
    void futureSubscriptionQueryWithMultipleResponses() {
        GenericSubscriptionQueryMessage queryMessage = new GenericSubscriptionQueryMessage((Object)"criteria", "myQueryFutureWithMultipleResponses", ResponseTypes.multipleInstancesOf(String.class), ResponseTypes.instanceOf(String.class));
        Mono response = this.queryBus.subscriptionQuery((SubscriptionQueryMessage)queryMessage).initialResult().map(Message::getPayload);
        StepVerifier.create((Publisher)response).expectNext(Arrays.asList("Response1", "Response2")).verifyComplete();
    }

    private static class MyQueryHandler {
        private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

        private MyQueryHandler() {
        }

        @QueryHandler(queryName="myQueryWithMultipleResponses")
        public CompletableFuture<List<String>> queryHandler1(String criteria) {
            CompletableFuture<List<String>> completableFuture = new CompletableFuture<List<String>>();
            this.executor.schedule(() -> completableFuture.complete(Arrays.asList("Response1", "Response2")), 500L, TimeUnit.MILLISECONDS);
            return completableFuture;
        }

        @QueryHandler(queryName="myQueryWithSingleResponse")
        public Future<String> queryHandler2(String criteria) {
            return this.executor.schedule(() -> "Response", 500L, TimeUnit.MILLISECONDS);
        }

        @QueryHandler(queryName="myQueryFutureWithMultipleResponses")
        public Future<List<String>> queryHandler3(String criteria) {
            return this.executor.schedule(() -> Arrays.asList("Response1", "Response2"), 500L, TimeUnit.MILLISECONDS);
        }
    }
}

