/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.Collections;
import java.util.Map;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.GenericResultMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.queryhandling.GenericSubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericSubscriptionQueryUpdateMessageTest {
    GenericSubscriptionQueryUpdateMessageTest() {
    }

    @Test
    void messageCreation() {
        String payload = "payload";
        SubscriptionQueryUpdateMessage result = GenericSubscriptionQueryUpdateMessage.asUpdateMessage((Object)payload);
        Assertions.assertEquals((Object)payload, (Object)result.getPayload());
    }

    @Test
    void messageCreationWithNullPayload() {
        Object payload = null;
        GenericSubscriptionQueryUpdateMessage result = new GenericSubscriptionQueryUpdateMessage(String.class, payload);
        Assertions.assertNull((Object)result.getPayload());
    }

    @Test
    void andMetaData() {
        Map<String, String> metaData = Collections.singletonMap("k1", "v2");
        GenericSubscriptionQueryUpdateMessage original = new GenericSubscriptionQueryUpdateMessage((Message)new GenericMessage((Object)"payload", metaData));
        Map<String, String> newMetaData = Collections.singletonMap("k2", "v3");
        SubscriptionQueryUpdateMessage result = original.andMetaData(newMetaData);
        Assertions.assertEquals((Object)original.getPayload(), (Object)result.getPayload());
        MetaData expectedMetaData = MetaData.from(metaData).mergedWith(newMetaData);
        Assertions.assertEquals((Object)expectedMetaData, (Object)result.getMetaData());
    }

    @Test
    void withMetaData() {
        Map<String, String> metaData = Collections.singletonMap("k1", "v2");
        GenericSubscriptionQueryUpdateMessage original = new GenericSubscriptionQueryUpdateMessage((Message)new GenericMessage((Object)"payload", metaData));
        Map<String, String> newMetaData = Collections.singletonMap("k2", "v3");
        SubscriptionQueryUpdateMessage result = original.withMetaData(newMetaData);
        Assertions.assertEquals((Object)original.getPayload(), (Object)result.getPayload());
        Assertions.assertEquals(newMetaData, (Object)result.getMetaData());
    }

    @Test
    void messageCreationBasedOnExistingMessage() {
        GenericSubscriptionQueryUpdateMessage original = new GenericSubscriptionQueryUpdateMessage((Object)"payload");
        SubscriptionQueryUpdateMessage result = GenericSubscriptionQueryUpdateMessage.asUpdateMessage((Object)original);
        Assertions.assertEquals((Object)result, (Object)original);
    }

    @Test
    void messageCreationBasedOnResultMessage() {
        Map<String, String> metaData = Collections.singletonMap("k1", "v1");
        CommandResultMessage resultMessage = GenericCommandResultMessage.asCommandResultMessage((Object)new GenericResultMessage((Object)"result", metaData));
        SubscriptionQueryUpdateMessage result = GenericSubscriptionQueryUpdateMessage.asUpdateMessage((Object)resultMessage);
        Assertions.assertEquals((Object)result.getPayload(), (Object)resultMessage.getPayload());
        Assertions.assertEquals((Object)result.getMetaData(), (Object)resultMessage.getMetaData());
    }

    @Test
    void messageCreationBasedOnExceptionalResultMessage() {
        Map<String, String> metaData = Collections.singletonMap("k1", "v1");
        RuntimeException exception = new RuntimeException();
        CommandResultMessage resultMessage = GenericCommandResultMessage.asCommandResultMessage((Object)new GenericResultMessage((Throwable)exception, metaData));
        SubscriptionQueryUpdateMessage result = GenericSubscriptionQueryUpdateMessage.asUpdateMessage((Object)resultMessage);
        Assertions.assertEquals((Object)result.getMetaData(), (Object)resultMessage.getMetaData());
        Assertions.assertTrue((boolean)result.isExceptional());
        Assertions.assertEquals((Object)exception, (Object)result.exceptionResult());
    }

    @Test
    void messageCreationBasedOnAnyMessage() {
        Map<String, String> metaData = Collections.singletonMap("k1", "v1");
        GenericMessage message = new GenericMessage((Object)"payload", metaData);
        SubscriptionQueryUpdateMessage result = GenericSubscriptionQueryUpdateMessage.asUpdateMessage((Object)message);
        Assertions.assertEquals((Object)result.getPayload(), (Object)message.getPayload());
        Assertions.assertEquals((Object)result.getMetaData(), (Object)message.getMetaData());
    }
}

