/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Documented;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.axonframework.serialization.CannotConvertBetweenTypesException;
import org.axonframework.serialization.ChainedConverter;
import org.axonframework.serialization.ContentTypeConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ChainedConverterTest {
    private ContentTypeConverter testSubject;
    private Object source;
    private Class<?> target;
    private List<ContentTypeConverter<?, ?>> candidates;
    private ContentTypeConverter<?, ?> stringToReaderConverter;
    private ContentTypeConverter<?, ?> stringToByteConverter;
    private ContentTypeConverter<?, ?> bytesToInputStreamConverter;
    private ContentTypeConverter<?, ?> numberToStringConverter;

    ChainedConverterTest() {
    }

    @BeforeEach
    void setUp() {
        this.candidates = new ArrayList();
        this.numberToStringConverter = this.mockConverter(Number.class, String.class, "hello");
        this.stringToByteConverter = this.mockConverter(String.class, byte[].class, "hello".getBytes());
        this.stringToReaderConverter = this.mockConverter(String.class, Reader.class, new StringReader("hello"));
        this.bytesToInputStreamConverter = this.mockConverter(byte[].class, InputStream.class, new ByteArrayInputStream("hello".getBytes()));
        ContentTypeConverter<?, ?> inputStreamToNumberConverter = this.mockConverter(InputStream.class, byte[].class, "hello".getBytes());
        this.candidates.add(this.stringToByteConverter);
        this.candidates.add(this.stringToReaderConverter);
        this.candidates.add(this.bytesToInputStreamConverter);
        this.candidates.add(inputStreamToNumberConverter);
        this.candidates.add(this.numberToStringConverter);
    }

    private ContentTypeConverter<?, ?> mockConverter(Class<?> expectedType, Class<?> targetType, Object representation) {
        ContentTypeConverter mock = (ContentTypeConverter)Mockito.mock(ContentTypeConverter.class);
        Mockito.when((Object)mock.expectedSourceType()).thenReturn(expectedType);
        Mockito.when((Object)mock.targetType()).thenReturn(targetType);
        Mockito.when((Object)mock.convert(Mockito.any())).thenReturn(representation);
        return mock;
    }

    @Test
    void complexRoute() throws Exception {
        this.target = InputStream.class;
        this.source = 1L;
        this.testSubject = ChainedConverter.calculateChain(Number.class, this.target, this.candidates);
        Assertions.assertNotNull((Object)this.testSubject);
        ((ContentTypeConverter)Mockito.verify(this.numberToStringConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.stringToReaderConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.bytesToInputStreamConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.stringToByteConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        InputStream actual = (InputStream)this.convertSource();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertArrayEquals((byte[])"hello".getBytes(), (byte[])IOUtils.toByteArray((InputStream)actual));
        ((ContentTypeConverter)Mockito.verify(this.numberToStringConverter)).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.stringToByteConverter)).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.bytesToInputStreamConverter)).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.stringToReaderConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
    }

    private <T> T convertSource() {
        return (T)this.testSubject.convert(this.source);
    }

    @Test
    void simpleRoute() {
        this.target = String.class;
        this.source = 1L;
        this.testSubject = ChainedConverter.calculateChain(Number.class, this.target, this.candidates);
        Assertions.assertNotNull((Object)this.testSubject);
        ((ContentTypeConverter)Mockito.verify(this.numberToStringConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.stringToReaderConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.bytesToInputStreamConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.stringToByteConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        String actual = (String)this.convertSource();
        Assertions.assertEquals((Object)"hello", (Object)actual);
        ((ContentTypeConverter)Mockito.verify(this.numberToStringConverter)).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.stringToReaderConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.bytesToInputStreamConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
        ((ContentTypeConverter)Mockito.verify(this.stringToByteConverter, (VerificationMode)Mockito.never())).convert(Mockito.any());
    }

    @Test
    void inexistentRoute() {
        this.target = InputStream.class;
        this.source = new StringReader("hello");
        Assertions.assertThrows(CannotConvertBetweenTypesException.class, () -> ChainedConverter.calculateChain(Reader.class, this.target, this.candidates));
    }

    @Test
    void anotherInexistentRoute() {
        this.target = Number.class;
        this.source = "hello";
        Assertions.assertFalse((boolean)ChainedConverter.canConvert(String.class, this.target, this.candidates));
        Assertions.assertThrows(CannotConvertBetweenTypesException.class, () -> ChainedConverter.calculateChain(String.class, this.target, this.candidates));
    }

    @Test
    void aThirdInexistentRoute() {
        this.target = Documented.class;
        this.source = "hello".getBytes();
        Assertions.assertThrows(CannotConvertBetweenTypesException.class, () -> ChainedConverter.calculateChain(byte[].class, this.target, this.candidates));
    }

    @Test
    void discontinuousChainIsRejected() {
        try {
            this.testSubject = new ChainedConverter(Arrays.asList(this.numberToStringConverter, this.bytesToInputStreamConverter));
            Assertions.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("continuous chain"), (String)("Wrong message: " + e.getMessage()));
        }
    }
}

