/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class LazyDeserializingObjectTest {
    private Serializer mockSerializer;
    private SerializedType mockType;
    private SerializedObject mockObject;
    private String mockDeserializedObject = "I'm a mock";

    LazyDeserializingObjectTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockSerializer = (Serializer)Mockito.mock(Serializer.class);
        this.mockType = (SerializedType)Mockito.mock(SerializedType.class);
        this.mockObject = new SimpleSerializedObject((Object)this.mockDeserializedObject, String.class, this.mockType);
        Mockito.when((Object)this.mockSerializer.classForType(this.mockType)).thenReturn(String.class);
        Mockito.when((Object)this.mockSerializer.deserialize(this.mockObject)).thenReturn((Object)this.mockDeserializedObject);
    }

    @Test
    void lazilyDeserialized() {
        LazyDeserializingObject testSubject = new LazyDeserializingObject(this.mockObject, this.mockSerializer);
        ((Serializer)Mockito.verify((Object)this.mockSerializer, (VerificationMode)Mockito.never())).deserialize((SerializedObject)Mockito.any(SerializedObject.class));
        Assertions.assertEquals(String.class, (Object)testSubject.getType());
        Assertions.assertFalse((boolean)testSubject.isDeserialized());
        ((Serializer)Mockito.verify((Object)this.mockSerializer, (VerificationMode)Mockito.never())).deserialize((SerializedObject)Mockito.any(SerializedObject.class));
        Assertions.assertSame((Object)this.mockDeserializedObject, (Object)testSubject.getObject());
        Assertions.assertTrue((boolean)testSubject.isDeserialized());
    }

    @Test
    void lazilyDeserialized_NullObject() {
        Assertions.assertThrows(Exception.class, () -> new LazyDeserializingObject(null, this.mockSerializer));
    }

    @Test
    void lazilyDeserialized_NullSerializer() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LazyDeserializingObject(this.mockObject, null));
    }

    @Test
    void withProvidedDeserializedInstance() {
        LazyDeserializingObject testSubject = new LazyDeserializingObject((Object)this.mockDeserializedObject);
        Assertions.assertEquals(this.mockDeserializedObject.getClass(), (Object)testSubject.getType());
        Assertions.assertSame((Object)this.mockDeserializedObject, (Object)testSubject.getObject());
        Assertions.assertTrue((boolean)testSubject.isDeserialized());
    }

    @Test
    void withProvidedDeserializedNullInstance() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LazyDeserializingObject(null));
    }
}

