/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SerializationAwareTest {
    private GenericEventMessage<String> testSubject;

    SerializationAwareTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new GenericEventMessage((Object)"payload", Collections.singletonMap("key", "value"));
    }

    @Test
    void isSerializedAsGenericEventMessage() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.testSubject);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        Object read = ois.readObject();
        Assertions.assertEquals(GenericEventMessage.class, read.getClass());
    }

    @Test
    void serializePayloadTwice() {
        Serializer serializer = (Serializer)Mockito.mock(Serializer.class);
        ChainingConverter converter = new ChainingConverter();
        Mockito.when((Object)serializer.getConverter()).thenReturn((Object)converter);
        SimpleSerializedObject serializedObject = new SimpleSerializedObject((Object)"payload".getBytes(), byte[].class, "String", "0");
        Mockito.when((Object)serializer.serialize((Object)"payload", byte[].class)).thenReturn((Object)serializedObject);
        SerializedObject actual1 = this.testSubject.serializePayload(serializer, byte[].class);
        SerializedObject actual2 = this.testSubject.serializePayload(serializer, byte[].class);
        Assertions.assertSame((Object)actual1, (Object)actual2);
        ((Serializer)Mockito.verify((Object)serializer, (VerificationMode)Mockito.times((int)1))).serialize((Object)"payload", byte[].class);
        ((Serializer)Mockito.verify((Object)serializer)).getConverter();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{serializer});
    }

    @Test
    void serializePayloadTwice_DifferentRepresentations() {
        Serializer serializer = (Serializer)Mockito.mock(Serializer.class);
        ChainingConverter converter = new ChainingConverter();
        Mockito.when((Object)serializer.getConverter()).thenReturn((Object)converter);
        SimpleSerializedObject serializedObject = new SimpleSerializedObject((Object)"payload".getBytes(), byte[].class, "String", "0");
        Mockito.when((Object)serializer.serialize((Object)"payload", byte[].class)).thenReturn((Object)serializedObject);
        SerializedObject actual1 = this.testSubject.serializePayload(serializer, byte[].class);
        SerializedObject actual2 = this.testSubject.serializePayload(serializer, String.class);
        Assertions.assertNotSame((Object)actual1, (Object)actual2);
        Assertions.assertEquals(String.class, (Object)actual2.getContentType());
        ((Serializer)Mockito.verify((Object)serializer, (VerificationMode)Mockito.times((int)1))).serialize((Object)"payload", byte[].class);
        ((Serializer)Mockito.verify((Object)serializer)).getConverter();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{serializer});
    }

    @Test
    void serializeMetaDataTwice() {
        Serializer serializer = (Serializer)Mockito.mock(Serializer.class);
        ChainingConverter converter = new ChainingConverter();
        Mockito.when((Object)serializer.getConverter()).thenReturn((Object)converter);
        SimpleSerializedObject serializedObject = new SimpleSerializedObject((Object)"payload".getBytes(), byte[].class, "String", "0");
        Mockito.when((Object)serializer.serialize(Mockito.isA(MetaData.class), (Class)Mockito.eq(byte[].class))).thenReturn((Object)serializedObject);
        this.testSubject.serializeMetaData(serializer, byte[].class);
        this.testSubject.serializeMetaData(serializer, byte[].class);
        ((Serializer)Mockito.verify((Object)serializer, (VerificationMode)Mockito.times((int)1))).serialize(Mockito.isA(MetaData.class), (Class)Mockito.eq(byte[].class));
        ((Serializer)Mockito.verify((Object)serializer)).getConverter();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{serializer});
    }

    @Test
    void serializeMetaDataTwice_DifferentRepresentations() {
        Serializer serializer = (Serializer)Mockito.mock(Serializer.class);
        ChainingConverter converter = new ChainingConverter();
        Mockito.when((Object)serializer.getConverter()).thenReturn((Object)converter);
        SimpleSerializedObject serializedObject = new SimpleSerializedObject((Object)"payload".getBytes(), byte[].class, "String", "0");
        Mockito.when((Object)serializer.serialize(Mockito.isA(MetaData.class), (Class)Mockito.eq(byte[].class))).thenReturn((Object)serializedObject);
        SerializedObject actual1 = this.testSubject.serializeMetaData(serializer, byte[].class);
        SerializedObject actual2 = this.testSubject.serializeMetaData(serializer, String.class);
        Assertions.assertNotSame((Object)actual1, (Object)actual2);
        Assertions.assertEquals(String.class, (Object)actual2.getContentType());
        ((Serializer)Mockito.verify((Object)serializer, (VerificationMode)Mockito.times((int)1))).serialize(Mockito.isA(MetaData.class), (Class)Mockito.eq(byte[].class));
        ((Serializer)Mockito.verify((Object)serializer)).getConverter();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{serializer});
    }
}

