/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import java.io.IOException;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.SchemaStore;
import org.axonframework.serialization.avro.ByteArrayToGenericRecordConverter;
import org.axonframework.serialization.avro.GenericRecordToByteArrayConverter;
import org.axonframework.serialization.avro.test.ComplexObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GenericRecordConverterTest {
    private final SchemaStore.Cache schemaStore = new SchemaStore.Cache();
    private final GenericRecordToByteArrayConverter toByteArrayConverter = new GenericRecordToByteArrayConverter();
    private final ByteArrayToGenericRecordConverter toGenericRecordConverter = new ByteArrayToGenericRecordConverter((SchemaStore)this.schemaStore);

    @BeforeEach
    void setUp() {
        this.schemaStore.addSchema(ComplexObject.getClassSchema());
    }

    @Test
    void convertBackAndForth() throws IOException {
        GenericData.Record record = new GenericData.Record(ComplexObject.getClassSchema());
        record.put("value1", (Object)"foo");
        record.put("value2", (Object)"bar");
        record.put("value3", (Object)4711);
        byte[] singleObjectEncodedBytes = this.toByteArrayConverter.convert((GenericRecord)record);
        GenericRecord convertedRecord = this.toGenericRecordConverter.convert(singleObjectEncodedBytes);
        Assertions.assertEquals((Object)record, (Object)convertedRecord);
    }
}

