/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.UnknownSerializedType;
import org.axonframework.serialization.json.JacksonSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class JacksonSerializerTest {
    private ObjectMapper objectMapper;
    private Instant time;
    private JacksonSerializer testSubject;

    JacksonSerializerTest() {
    }

    @BeforeEach
    void setUp() {
        this.objectMapper = new ObjectMapper();
        this.time = Instant.now();
        this.testSubject = JacksonSerializer.builder().objectMapper(this.objectMapper).build();
    }

    @Test
    void canSerializeToByteArrayStringInputStreamJsonNodeAndObjectNode() {
        Assertions.assertTrue((boolean)this.testSubject.canSerializeTo(byte[].class));
        Assertions.assertTrue((boolean)this.testSubject.canSerializeTo(String.class));
        Assertions.assertTrue((boolean)this.testSubject.canSerializeTo(InputStream.class));
        Assertions.assertTrue((boolean)this.testSubject.canSerializeTo(JsonNode.class));
        Assertions.assertTrue((boolean)this.testSubject.canSerializeTo(ObjectNode.class));
    }

    @Test
    void serializeAndDeserializeObject_StringFormat() {
        SimpleSerializableType toSerialize = new SimpleSerializableType("first", this.time, new SimpleSerializableType("nested"));
        SerializedObject serialized = this.testSubject.serialize((Object)toSerialize, String.class);
        SimpleSerializableType actual = (SimpleSerializableType)this.testSubject.deserialize(serialized);
        Assertions.assertEquals((Object)toSerialize.getValue(), (Object)actual.getValue());
        Assertions.assertEquals((Object)toSerialize.getNested().getValue(), (Object)actual.getNested().getValue());
    }

    @Test
    void serializeAndDeserializeArray() {
        SimpleSerializableType toSerialize = new SimpleSerializableType("first", this.time, new SimpleSerializableType("nested"));
        SerializedObject serialized = this.testSubject.serialize((Object)new SimpleSerializableType[]{toSerialize}, String.class);
        SimpleSerializableType[] actual = (SimpleSerializableType[])this.testSubject.deserialize(serialized);
        Assertions.assertEquals((int)1, (int)actual.length);
        Assertions.assertEquals((Object)toSerialize.getValue(), (Object)actual[0].getValue());
        Assertions.assertEquals((Object)toSerialize.getNested().getValue(), (Object)actual[0].getNested().getValue());
    }

    @Test
    void serializeAndDeserializeList() {
        this.objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_CONCRETE_AND_ARRAYS);
        SimpleSerializableType toSerialize = new SimpleSerializableType("first", this.time, new SimpleSerializableType("nested"));
        SerializedObject serialized = this.testSubject.serialize(Collections.singletonList(toSerialize), String.class);
        List actual = (List)this.testSubject.deserialize(serialized);
        Assertions.assertEquals((int)1, (int)actual.size());
        Assertions.assertEquals((Object)toSerialize.getValue(), (Object)((SimpleSerializableType)actual.get(0)).getValue());
        Assertions.assertEquals((Object)toSerialize.getNested().getValue(), (Object)((SimpleSerializableType)actual.get(0)).getNested().getValue());
    }

    @Test
    void serializeAndDeserializeObject_ByteArrayFormat() {
        SimpleSerializableType toSerialize = new SimpleSerializableType("first", this.time, new SimpleSerializableType("nested"));
        SerializedObject serialized = this.testSubject.serialize((Object)toSerialize, byte[].class);
        SimpleSerializableType actual = (SimpleSerializableType)this.testSubject.deserialize(serialized);
        Assertions.assertEquals((Object)toSerialize.getValue(), (Object)actual.getValue());
        Assertions.assertEquals((Object)toSerialize.getNested().getValue(), (Object)actual.getNested().getValue());
    }

    @Test
    void serializeAndDeserializeObjectUnknownType() {
        SimpleSerializableType toSerialize = new SimpleSerializableType("first", this.time, new SimpleSerializableType("nested"));
        SerializedObject serialized = this.testSubject.serialize((Object)toSerialize, byte[].class);
        Object actual = this.testSubject.deserialize((SerializedObject)new SimpleSerializedObject(serialized.getData(), byte[].class, "someUnknownType", "42.1"));
        Assertions.assertTrue((boolean)(actual instanceof UnknownSerializedType));
        UnknownSerializedType actualUnknown = (UnknownSerializedType)actual;
        Assertions.assertTrue((boolean)actualUnknown.supportsFormat(JsonNode.class));
        JsonNode actualJson = (JsonNode)actualUnknown.readData(JsonNode.class);
        Assertions.assertEquals((Object)"first", (Object)actualJson.get("value").asText());
        Assertions.assertEquals((Object)"nested", (Object)actualJson.path("nested").path("value").asText());
    }

    @Test
    void readUnknownSerializedTypeCachesLookupResults() {
        ObjectMapper spiedMapper = (ObjectMapper)Mockito.spy((Object)this.objectMapper);
        this.testSubject = JacksonSerializer.builder().objectMapper(spiedMapper).build();
        SimpleSerializedObject testObject = new SimpleSerializedObject((Object)"{\"data\" : \"value\"}", String.class, "my.nonexistent.Class", null);
        for (int i = 0; i < 10; ++i) {
            Class actual = this.testSubject.classForType(testObject.getType());
            Assertions.assertEquals(UnknownSerializedType.class, (Object)actual);
        }
        ((ObjectMapper)Mockito.verify((Object)spiedMapper, (VerificationMode)Mockito.times((int)1))).getTypeFactory();
    }

    @Test
    void readUnknownSerializedTypeWithCachingDisabled() {
        ObjectMapper spiedMapper = (ObjectMapper)Mockito.spy((Object)this.objectMapper);
        this.testSubject = JacksonSerializer.builder().objectMapper(spiedMapper).disableCachingOfUnknownClasses().build();
        SimpleSerializedObject testObject = new SimpleSerializedObject((Object)"{\"data\" : \"value\"}", String.class, "my.nonexistent.Class", null);
        for (int i = 0; i < 10; ++i) {
            Class actual = this.testSubject.classForType(testObject.getType());
            Assertions.assertEquals(UnknownSerializedType.class, (Object)actual);
        }
        ((ObjectMapper)Mockito.verify((Object)spiedMapper, (VerificationMode)Mockito.times((int)10))).getTypeFactory();
    }

    @Test
    void serializeAndDeserializeObject_JsonNodeFormat() {
        SimpleSerializableType toSerialize = new SimpleSerializableType("first", this.time, new SimpleSerializableType("nested"));
        SerializedObject serialized = this.testSubject.serialize((Object)toSerialize, JsonNode.class);
        SimpleSerializableType actual = (SimpleSerializableType)this.testSubject.deserialize(serialized);
        Assertions.assertEquals((Object)toSerialize.getValue(), (Object)actual.getValue());
        Assertions.assertEquals((Object)toSerialize.getNested().getValue(), (Object)actual.getNested().getValue());
    }

    @Test
    void customObjectMapperRevisionResolverAndConverter() {
        RevisionResolver revisionResolver = (RevisionResolver)Mockito.spy((Object)new AnnotationRevisionResolver());
        ChainingConverter converter = (ChainingConverter)Mockito.spy((Object)new ChainingConverter());
        ObjectMapper objectMapper = (ObjectMapper)Mockito.spy((Object)new ObjectMapper());
        this.testSubject = JacksonSerializer.builder().revisionResolver(revisionResolver).converter((Converter)converter).objectMapper(objectMapper).build();
        SerializedObject serialized = this.testSubject.serialize((Object)new SimpleSerializableType("test"), byte[].class);
        SimpleSerializableType actual = (SimpleSerializableType)this.testSubject.deserialize(serialized);
        Assertions.assertNotNull((Object)actual);
        ((ObjectMapper)Mockito.verify((Object)objectMapper)).readerFor(SimpleSerializableType.class);
        ((ObjectMapper)Mockito.verify((Object)objectMapper)).writer();
        ((RevisionResolver)Mockito.verify((Object)revisionResolver)).revisionOf(SimpleSerializableType.class);
        ((ChainingConverter)Mockito.verify((Object)converter, (VerificationMode)Mockito.times((int)4))).registerConverter((ContentTypeConverter)Mockito.isA(ContentTypeConverter.class));
        Assertions.assertSame((Object)objectMapper, (Object)this.testSubject.getObjectMapper());
    }

    @Test
    void customObjectMapperAndRevisionResolver() {
        ObjectMapper objectMapper = (ObjectMapper)Mockito.spy((Object)new ObjectMapper());
        RevisionResolver revisionResolver = (RevisionResolver)Mockito.spy((Object)new AnnotationRevisionResolver());
        this.testSubject = JacksonSerializer.builder().revisionResolver(revisionResolver).objectMapper(objectMapper).build();
        SerializedObject serialized = this.testSubject.serialize((Object)new SimpleSerializableType("test"), byte[].class);
        SimpleSerializableType actual = (SimpleSerializableType)this.testSubject.deserialize(serialized);
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)(this.testSubject.getConverter() instanceof ChainingConverter));
        ((ObjectMapper)Mockito.verify((Object)objectMapper)).readerFor(SimpleSerializableType.class);
        ((ObjectMapper)Mockito.verify((Object)objectMapper)).writer();
        ((RevisionResolver)Mockito.verify((Object)revisionResolver)).revisionOf(SimpleSerializableType.class);
    }

    @Test
    void customObjectMapper() {
        ObjectMapper objectMapper = (ObjectMapper)Mockito.spy((Object)new ObjectMapper());
        this.testSubject = JacksonSerializer.builder().objectMapper(objectMapper).build();
        SerializedObject serialized = this.testSubject.serialize((Object)new SimpleSerializableType("test"), byte[].class);
        SimpleSerializableType actual = (SimpleSerializableType)this.testSubject.deserialize(serialized);
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)(this.testSubject.getConverter() instanceof ChainingConverter));
        ((ObjectMapper)Mockito.verify((Object)objectMapper)).readerFor(SimpleSerializableType.class);
        ((ObjectMapper)Mockito.verify((Object)objectMapper)).writer();
    }

    @Test
    void serializeMetaData() {
        this.testSubject = JacksonSerializer.builder().build();
        SerializedObject serialized = this.testSubject.serialize((Object)MetaData.from(Collections.singletonMap("test", "test")), byte[].class);
        MetaData actual = (MetaData)this.testSubject.deserialize(serialized);
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)"test", (Object)actual.get((Object)"test"));
        Assertions.assertEquals((int)1, (int)actual.size());
    }

    @Test
    void serializeMetaDataWithComplexObjects() {
        JacksonSerializer testSubject = JacksonSerializer.builder().defaultTyping().build();
        MetaData metaData = MetaData.with((String)"myKey", (Object)new ComplexObject("String1", "String2", 3));
        SerializedObject serialized = testSubject.serialize((Object)metaData, byte[].class);
        MetaData actual = (MetaData)testSubject.deserialize(serialized);
        Assertions.assertEquals((Object)metaData, (Object)actual);
    }

    @Test
    void serializeCollectionOfObjects() {
        JacksonSerializer testSubject = JacksonSerializer.builder().defaultTyping().build();
        ArrayList<ComplexObject> objectToSerialize = new ArrayList<ComplexObject>();
        objectToSerialize.add(new ComplexObject("String1", "String2", 3));
        objectToSerialize.add(new ComplexObject("String4", "String5", 6));
        objectToSerialize.add(new ComplexObject("String7", "String8", 9));
        SerializedObject serializedResult = testSubject.serialize(objectToSerialize, String.class);
        List deserializedResult = (List)testSubject.deserialize(serializedResult);
        Assertions.assertEquals(objectToSerialize, (Object)deserializedResult);
    }

    @Test
    void deserializeNullValue() {
        SerializedObject serializedNull = this.testSubject.serialize(null, byte[].class);
        SimpleSerializedObject serializedNullString = new SimpleSerializedObject(serializedNull.getData(), byte[].class, this.testSubject.typeForClass(String.class));
        Assertions.assertNull((Object)this.testSubject.deserialize(serializedNull));
        Assertions.assertNull((Object)this.testSubject.deserialize((SerializedObject)serializedNullString));
    }

    @Test
    void deserializeEmptyBytes() {
        Assertions.assertEquals(Void.class, (Object)this.testSubject.classForType(SerializedType.emptyType()));
        Assertions.assertNull((Object)this.testSubject.deserialize((SerializedObject)new SimpleSerializedObject((Object)new byte[0], byte[].class, SerializedType.emptyType())));
    }

    @Test
    void deserializeLenientIgnoresUnknownValues() {
        this.testSubject = JacksonSerializer.builder().lenientDeserialization().objectMapper(this.objectMapper).build();
        SerializedObject serialized = this.testSubject.serialize((Object)new ComplexObject("one", "two", 3), JsonNode.class);
        ObjectNode data = (ObjectNode)serialized.getData();
        JsonNodeFactory nf = this.objectMapper.getNodeFactory();
        data.set("newField", (JsonNode)nf.textNode("newValue"));
        ArrayNode arrayNode = nf.arrayNode().add((JsonNode)data);
        ComplexObject actual = (ComplexObject)this.testSubject.deserialize((SerializedObject)new SimpleSerializedObject((Object)arrayNode, JsonNode.class, serialized.getType()));
        Assertions.assertEquals((Object)"one", (Object)actual.getValue1());
        Assertions.assertEquals((Object)"two", (Object)actual.getValue2());
        Assertions.assertEquals((int)3, (int)actual.getValue3());
    }

    @Test
    void serializeAndDeserializeObjectObjectNodeFormat() {
        SimpleSerializableType toSerialize = new SimpleSerializableType("first", this.time, new SimpleSerializableType("nested"));
        SerializedObject serialized = this.testSubject.serialize((Object)toSerialize, ObjectNode.class);
        SimpleSerializableType actual = (SimpleSerializableType)this.testSubject.deserialize(serialized);
        Assertions.assertEquals((Object)toSerialize.getValue(), (Object)actual.getValue());
        Assertions.assertEquals((Object)toSerialize.getNested().getValue(), (Object)actual.getNested().getValue());
    }

    @Test
    void configuredRevisionResolverIsReturned() {
        String expectedRevision = "some-revision";
        RevisionResolver expectedRevisionResolver = payloadType -> expectedRevision;
        JacksonSerializer customTestSubject = JacksonSerializer.builder().revisionResolver(expectedRevisionResolver).build();
        RevisionResolver result = customTestSubject.getRevisionResolver();
        Assertions.assertEquals((Object)expectedRevisionResolver, (Object)result);
        Assertions.assertEquals((Object)expectedRevision, (Object)result.revisionOf(String.class));
    }

    public static class SimpleSerializableType {
        private final String value;
        private final Instant time;
        private final SimpleSerializableType nested;

        public SimpleSerializableType(String value) {
            this(value, Instant.now(), null);
        }

        @JsonCreator
        public SimpleSerializableType(@JsonProperty(value="value") String value, @JsonProperty(value="time") Instant time, @JsonProperty(value="nested") SimpleSerializableType nested) {
            this.value = value;
            this.time = time;
            this.nested = nested;
        }

        public SimpleSerializableType getNested() {
            return this.nested;
        }

        public String getValue() {
            return this.value;
        }

        public Instant getTime() {
            return this.time;
        }
    }

    public static class ComplexObject {
        private final String value1;
        private final String value2;
        private final int value3;

        @JsonCreator
        public ComplexObject(@JsonProperty(value="value1") String value1, @JsonProperty(value="value2") String value2, @JsonProperty(value="value3") int value3) {
            this.value1 = value1;
            this.value2 = value2;
            this.value3 = value3;
        }

        public String getValue1() {
            return this.value1;
        }

        public String getValue2() {
            return this.value2;
        }

        public int getValue3() {
            return this.value3;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComplexObject that = (ComplexObject)o;
            return this.value3 == that.value3 && Objects.equals(this.value1, that.value1) && Objects.equals(this.value2, that.value2);
        }

        public int hashCode() {
            return Objects.hash(this.value1, this.value2, this.value3);
        }
    }
}

