/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.json.MetaDataDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MetaDataDeserializerTest {
    MetaDataDeserializerTest() {
    }

    public static Stream<Arguments> objectMappers() {
        return Stream.of(null, ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, ObjectMapper.DefaultTyping.NON_CONCRETE_AND_ARRAYS, ObjectMapper.DefaultTyping.NON_FINAL, ObjectMapper.DefaultTyping.OBJECT_AND_NON_CONCRETE).map(defaultTyping -> Arguments.of((Object[])new Object[]{MetaDataDeserializerTest.objectMapper(defaultTyping), defaultTyping}));
    }

    private static ObjectMapper objectMapper(ObjectMapper.DefaultTyping defaultTyping) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new SimpleModule("Axon-Jackson Module").addDeserializer(MetaData.class, (JsonDeserializer)new MetaDataDeserializer()));
        if (defaultTyping != null) {
            objectMapper.enableDefaultTyping(defaultTyping);
        }
        return objectMapper;
    }

    @MethodSource(value={"objectMappers"})
    @ParameterizedTest
    void metaDataSerializationWithDefaultTyping(ObjectMapper objectMapper) throws IOException {
        MetaData metaData = new MetaData(Collections.singletonMap("one", "two"));
        String serializedString = objectMapper.writeValueAsString((Object)metaData);
        MetaData deserialized = (MetaData)objectMapper.readValue(serializedString, MetaData.class);
        Assertions.assertEquals((Object)"two", (Object)deserialized.get((Object)"one"));
        Assertions.assertEquals((Object)serializedString, (Object)objectMapper.writeValueAsString((Object)deserialized));
    }

    @MethodSource(value={"objectMappers"})
    @ParameterizedTest
    void emptyMetaDataSerializationWithDefaultTyping(ObjectMapper objectMapper) throws IOException {
        MetaData metaData1 = new MetaData(new HashMap());
        String emptySerializedString = objectMapper.writeValueAsString((Object)metaData1);
        MetaData deserialized = (MetaData)objectMapper.readValue(emptySerializedString, MetaData.class);
        Assertions.assertTrue((boolean)deserialized.entrySet().isEmpty());
        Assertions.assertEquals((Object)emptySerializedString, (Object)objectMapper.writeValueAsString((Object)deserialized));
    }

    @MethodSource(value={"objectMappers"})
    @ParameterizedTest
    void metaDataContainerWithDefaultTyping(ObjectMapper objectMapper) throws IOException {
        MetaData metaData = new MetaData(Collections.singletonMap("one", "two"));
        Container container = new Container("a", metaData, 1);
        String serializedContainerString = objectMapper.writeValueAsString((Object)container);
        Container deserialized = (Container)objectMapper.readValue(serializedContainerString, Container.class);
        Assertions.assertEquals((Object)"two", (Object)deserialized.b.get((Object)"one"));
        Assertions.assertEquals((Object)serializedContainerString, (Object)objectMapper.writeValueAsString((Object)deserialized));
    }

    @MethodSource(value={"objectMappers"})
    @ParameterizedTest
    void metaDataContainerWithDataInDataWithDefaultTyping(ObjectMapper objectMapper, ObjectMapper.DefaultTyping defaultTyping) throws IOException {
        MetaData metaData = new MetaData(Collections.singletonMap("one", "two"));
        HashMap<String, MetaData> map2 = new HashMap<String, MetaData>();
        map2.put("one", metaData);
        MetaData dataInData = new MetaData(map2);
        Container container2 = new Container("a", dataInData, 1);
        String serializedDataInDataString = objectMapper.writeValueAsString((Object)container2);
        Container deserialized = (Container)objectMapper.readValue(serializedDataInDataString, Container.class);
        if (defaultTyping != null) {
            Assertions.assertEquals((Object)((MetaData)deserialized.b.get((Object)"one")).get((Object)"one"), (Object)"two");
        } else {
            Assertions.assertEquals(((Map)deserialized.b.get((Object)"one")).get("one"), (Object)"two");
        }
        Assertions.assertEquals((Object)serializedDataInDataString, (Object)objectMapper.writeValueAsString((Object)deserialized));
    }

    public static class Container {
        private String a;
        private MetaData b;
        private Integer c;

        @JsonCreator
        public Container(@JsonProperty(value="a") String a, @JsonProperty(value="b") MetaData b, @JsonProperty(value="c") Integer c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public MetaData getB() {
            return this.b;
        }

        public void setB(MetaData b) {
            this.b = b;
        }

        public Integer getC() {
            return this.c;
        }

        public void setC(Integer c) {
            this.c = c;
        }
    }
}

