/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.serialization.upcasting.GenericUpcasterChain;
import org.axonframework.serialization.upcasting.SingleEntryUpcaster;
import org.axonframework.serialization.upcasting.Upcaster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericUpcasterChainTest {
    GenericUpcasterChainTest() {
    }

    @Test
    void chainWithSingleUpcasterCanUpcastMultipleEvents() {
        String a = "a";
        String b = "b";
        String c = "c";
        GenericUpcasterChain testSubject = new GenericUpcasterChain(new Upcaster[]{new AToBUpcaster(a, b)});
        Stream result = testSubject.upcast(Stream.of(a, b, a, c));
        Assertions.assertEquals(Arrays.asList(b, b, b, c), result.collect(Collectors.toList()));
    }

    @Test
    void upcastingResultOfOtherUpcaster() {
        String a = "a";
        String b = "b";
        String c = "c";
        GenericUpcasterChain testSubject = new GenericUpcasterChain(new Upcaster[]{new AToBUpcaster(a, b), new AToBUpcaster(b, c)});
        Stream result = testSubject.upcast(Stream.of(a, b, a, c));
        Assertions.assertEquals(Arrays.asList(c, c, c, c), result.collect(Collectors.toList()));
    }

    @Test
    void upcastingResultOfOtherUpcasterOnlyWorksIfUpcastersAreInCorrectOrder() {
        String a = "a";
        String b = "b";
        String c = "c";
        GenericUpcasterChain testSubject = new GenericUpcasterChain(new Upcaster[]{new AToBUpcaster(b, c), new AToBUpcaster(a, b)});
        Stream result = testSubject.upcast(Stream.of(a, b, a, c));
        Assertions.assertEquals(Arrays.asList(b, c, b, c), result.collect(Collectors.toList()));
    }

    @Test
    void remainderAddedAndUpcasted() {
        String a = "a";
        String b = "b";
        String c = "c";
        GenericUpcasterChain testSubject = new GenericUpcasterChain(new Upcaster[]{new UpcasterWithRemainder(a, b), new AToBUpcaster(b, c)});
        Stream result = testSubject.upcast(Stream.of(a, b, a, c));
        Assertions.assertEquals(Arrays.asList(a, c, a, c, a, c), result.collect(Collectors.toList()));
    }

    @Test
    void remainderReleasedAfterUpcasting() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        GenericUpcasterChain testSubject = new GenericUpcasterChain(new Upcaster[]{new ConditionalUpcaster(a, b, c), new ConditionalUpcaster(c, d, a)});
        Stream result = testSubject.upcast(Stream.of(a, d, a, b, d, a));
        Assertions.assertEquals(Arrays.asList(a, d, a, a), result.collect(Collectors.toList()));
    }

    @Test
    void upcastToMultipleTypes() {
        String a = "a";
        String b = "b";
        String c = "c";
        GenericUpcasterChain testSubject = new GenericUpcasterChain(new Upcaster[]{new MultipleTypesUpcaster(), new AToBUpcaster(b, c)});
        Stream result = testSubject.upcast(Stream.of(a, b, c));
        Assertions.assertEquals(Arrays.asList(a, a, c, c, c, c), result.collect(Collectors.toList()));
    }

    private static class MultipleTypesUpcaster
    implements Upcaster<Object> {
        private MultipleTypesUpcaster() {
        }

        public Stream<Object> upcast(Stream<Object> intermediateRepresentations) {
            return intermediateRepresentations.flatMap(entry -> Stream.of(entry, entry));
        }
    }

    private static class ConditionalUpcaster
    implements Upcaster<Object> {
        private final Object first;
        private final Object second;
        private final Object replacement;

        public ConditionalUpcaster(Object first, Object second, Object replacement) {
            this.first = first;
            this.second = second;
            this.replacement = replacement;
        }

        public Stream<Object> upcast(Stream<Object> intermediateRepresentations) {
            AtomicReference previous = new AtomicReference();
            return Stream.concat(intermediateRepresentations.filter(entry -> entry != this.first || !previous.compareAndSet(null, entry)).flatMap(entry -> {
                if (entry == this.second && previous.compareAndSet(this.first, null)) {
                    return Stream.of(this.replacement);
                }
                return Optional.ofNullable(previous.getAndSet(null)).map(cached -> Stream.of(cached, entry)).orElse(Stream.of(entry));
            }), Stream.generate(previous::get).limit(1L).filter(Objects::nonNull));
        }
    }

    private static class UpcasterWithRemainder
    implements Upcaster<Object> {
        private final List<Object> remainder;

        public UpcasterWithRemainder(Object ... remainder) {
            this.remainder = Arrays.asList(remainder);
        }

        public Stream<Object> upcast(Stream<Object> intermediateRepresentations) {
            return Stream.concat(intermediateRepresentations, this.remainder.stream());
        }
    }

    private static class AToBUpcaster
    extends SingleEntryUpcaster<Object> {
        private final Object a;
        private final Object b;

        private AToBUpcaster(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        protected boolean canUpcast(Object intermediateRepresentation) {
            return intermediateRepresentation == this.a;
        }

        protected Object doUpcast(Object intermediateRepresentation) {
            return this.b;
        }
    }
}

