/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.json.JacksonSerializer;
import org.axonframework.serialization.upcasting.Upcaster;
import org.axonframework.serialization.upcasting.event.ContextAwareSingleEventUpcaster;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.utils.SecondStubEvent;
import org.axonframework.utils.StubDomainEvent;
import org.axonframework.utils.TestDomainEventEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ContextAwareSingleEventUpcasterTest {
    private Upcaster<IntermediateEventRepresentation> upcaster;
    private Serializer serializer;
    private String expectedNewString;

    ContextAwareSingleEventUpcasterTest() {
    }

    @BeforeEach
    void setUp() {
        this.expectedNewString = "newNameValue";
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new ParameterNamesModule(JsonCreator.Mode.PROPERTIES));
        this.serializer = JacksonSerializer.builder().objectMapper(objectMapper).build();
        this.upcaster = new StubContextAwareSingleEventUpcaster(this.expectedNewString);
    }

    @Test
    void upcastsAddsContextValueFromFirstEvent() {
        int expectedNumberOfEvents = 2;
        String expectedContextEventString = "oldName";
        Integer expectedContextEventNumber = 1;
        String expectedRevisionNumber = "1";
        String expectedNewString = this.expectedNewString + "ContextAdded";
        MetaData testMetaData = MetaData.with((String)"key", (Object)"value");
        GenericDomainEventMessage firstTestEventMessage = new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)new SecondStubEvent(expectedContextEventString, expectedContextEventNumber), (Map)testMetaData);
        TestDomainEventEntry firstTestEventData = new TestDomainEventEntry((DomainEventMessage<?>)firstTestEventMessage, this.serializer);
        InitialEventRepresentation firstTestRepresentation = new InitialEventRepresentation((EventData)firstTestEventData, this.serializer);
        GenericDomainEventMessage secondTestEventMessage = new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)new StubDomainEvent("oldName"), (Map)testMetaData);
        TestDomainEventEntry secondTestEventData = new TestDomainEventEntry((DomainEventMessage<?>)secondTestEventMessage, this.serializer);
        InitialEventRepresentation secondTestRepresentation = new InitialEventRepresentation((EventData)secondTestEventData, this.serializer);
        Stream<IntermediateEventRepresentation> testEventRepresentationStream = Stream.of(firstTestRepresentation, secondTestRepresentation);
        List result = this.upcaster.upcast(testEventRepresentationStream).collect(Collectors.toList());
        Assertions.assertEquals((int)expectedNumberOfEvents, (int)result.size());
        IntermediateEventRepresentation firstEventResult = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertNull((Object)firstEventResult.getType().getRevision());
        Assertions.assertEquals((Object)firstTestEventData.getEventIdentifier(), (Object)firstEventResult.getMessageIdentifier());
        Assertions.assertEquals((Object)firstTestEventData.getTimestamp(), (Object)firstEventResult.getTimestamp());
        Assertions.assertEquals((Object)testMetaData, (Object)firstEventResult.getMetaData().getObject());
        SecondStubEvent contextEvent = (SecondStubEvent)this.serializer.deserialize(firstEventResult.getData());
        Assertions.assertEquals((Object)expectedContextEventString, (Object)contextEvent.getName());
        Assertions.assertEquals((Integer)expectedContextEventNumber, (Integer)contextEvent.getNumber());
        IntermediateEventRepresentation secondEventResult = (IntermediateEventRepresentation)result.get(1);
        Assertions.assertEquals((Object)expectedRevisionNumber, (Object)secondEventResult.getType().getRevision());
        Assertions.assertEquals((Object)secondTestEventData.getEventIdentifier(), (Object)secondEventResult.getMessageIdentifier());
        Assertions.assertEquals((Object)secondTestEventData.getTimestamp(), (Object)secondEventResult.getTimestamp());
        Assertions.assertEquals((Object)testMetaData, (Object)secondEventResult.getMetaData().getObject());
        StubDomainEvent upcastedEvent = (StubDomainEvent)this.serializer.deserialize(secondEventResult.getData());
        Assertions.assertEquals((Object)expectedNewString, (Object)upcastedEvent.getName());
    }

    private static class StubContextAwareSingleEventUpcaster
    extends ContextAwareSingleEventUpcaster<Map<Object, Object>> {
        private static final String CONTEXT_FIELD_KEY = "ContextField";
        static final String CONTEXT_FIELD_VALUE = "ContextAdded";
        private final SerializedType contextType = new SimpleSerializedType(SecondStubEvent.class.getName(), null);
        private final SerializedType targetType = new SimpleSerializedType(StubDomainEvent.class.getName(), null);
        private final String newStringValue;

        private StubContextAwareSingleEventUpcaster(String newStringValue) {
            this.newStringValue = newStringValue;
        }

        protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation, Map<Object, Object> context) {
            return this.isType(intermediateRepresentation.getType(), this.targetType) || this.isType(intermediateRepresentation.getType(), this.contextType);
        }

        private boolean isType(SerializedType foundType, SerializedType expectedType) {
            return foundType.equals(expectedType);
        }

        protected IntermediateEventRepresentation doUpcast(IntermediateEventRepresentation intermediateRepresentation, Map<Object, Object> context) {
            if (this.isContextEvent(intermediateRepresentation)) {
                context.put(CONTEXT_FIELD_KEY, CONTEXT_FIELD_VALUE);
                return intermediateRepresentation;
            }
            return intermediateRepresentation.upcastPayload((SerializedType)new SimpleSerializedType(this.targetType.getName(), "1"), JsonNode.class, jsonNode -> this.doUpcast((JsonNode)jsonNode, context));
        }

        private boolean isContextEvent(IntermediateEventRepresentation intermediateRepresentation) {
            return this.isType(intermediateRepresentation.getType(), this.contextType);
        }

        protected Map<Object, Object> buildContext() {
            return new HashMap<Object, Object>();
        }

        private JsonNode doUpcast(JsonNode eventJsonNode, Map<Object, Object> context) {
            if (!eventJsonNode.isObject()) {
                return eventJsonNode;
            }
            ObjectNode eventObjectNode = (ObjectNode)eventJsonNode;
            eventObjectNode.set("name", (JsonNode)new TextNode(this.newStringValue + context.get(CONTEXT_FIELD_KEY)));
            return eventObjectNode;
        }
    }
}

