/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.GenericDomainEventEntry;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.TrackedDomainEventData;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.json.JacksonSerializer;
import org.axonframework.serialization.upcasting.Upcaster;
import org.axonframework.serialization.upcasting.event.EventMultiUpcaster;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.utils.SecondStubEvent;
import org.axonframework.utils.StubDomainEvent;
import org.axonframework.utils.TestDomainEventEntry;
import org.axonframework.utils.ThirdStubEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class EventMultiUpcasterTest {
    private String expectedNewString;
    private Integer expectedNewInteger;
    private List<Boolean> expectedNewBooleans;
    private Serializer serializer;
    private Upcaster<IntermediateEventRepresentation> upcaster;

    EventMultiUpcasterTest() {
    }

    @BeforeEach
    void setUp() {
        this.expectedNewString = "newNameValue";
        this.expectedNewInteger = 42;
        this.expectedNewBooleans = new ArrayList<Boolean>();
        this.expectedNewBooleans.add(true);
        this.expectedNewBooleans.add(false);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new ParameterNamesModule(JsonCreator.Mode.PROPERTIES));
        this.serializer = JacksonSerializer.builder().objectMapper(objectMapper).build();
        this.upcaster = new StubEventMultiUpcaster(this.expectedNewString, this.expectedNewInteger, this.expectedNewBooleans);
    }

    @Test
    void upcasterIgnoresWrongEventType() {
        GenericDomainEventMessage testEventMessage = new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)"someString");
        TestDomainEventEntry testEventData = new TestDomainEventEntry((DomainEventMessage<?>)testEventMessage, this.serializer);
        IntermediateEventRepresentation testRepresentation = (IntermediateEventRepresentation)Mockito.spy((Object)new InitialEventRepresentation((EventData)testEventData, this.serializer));
        List result = this.upcaster.upcast(Stream.of(testRepresentation)).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)result.size());
        IntermediateEventRepresentation resultRepresentation = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertSame((Object)testRepresentation, (Object)resultRepresentation);
        ((IntermediateEventRepresentation)Mockito.verify((Object)testRepresentation, (VerificationMode)Mockito.never())).getData();
    }

    @Test
    void upcasterIgnoresWrongEventRevision() {
        String expectedRevisionNumber = "1";
        GenericDomainEventMessage testEventMessage = new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)new StubDomainEvent("oldName"));
        TestDomainEventEntry testEventData = new TestDomainEventEntry((DomainEventMessage<?>)testEventMessage, this.serializer);
        InitialEventRepresentation testRepresentation = new InitialEventRepresentation((EventData)testEventData, this.serializer);
        List result = this.upcaster.upcast(Stream.of(testRepresentation)).collect(Collectors.toList());
        testRepresentation = (IntermediateEventRepresentation)Mockito.spy(result.get(0));
        Assertions.assertEquals((Object)expectedRevisionNumber, (Object)testRepresentation.getType().getRevision());
        result = this.upcaster.upcast(Stream.of(testRepresentation)).collect(Collectors.toList());
        Assertions.assertFalse((boolean)result.isEmpty());
        IntermediateEventRepresentation resultRepresentation = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertSame((Object)testRepresentation, (Object)resultRepresentation);
        ((IntermediateEventRepresentation)Mockito.verify((Object)testRepresentation, (VerificationMode)Mockito.never())).getData();
    }

    @Test
    void upcastingDomainEventData() {
        String testAggregateType = "test";
        String testAggregateId = "aggregateId";
        GlobalSequenceTrackingToken testTrackingToken = new GlobalSequenceTrackingToken(10L);
        long testSequenceNumber = 100L;
        SerializedObject testPayload = this.serializer.serialize((Object)new StubDomainEvent("oldName"), String.class);
        TrackedDomainEventData testEventData = new TrackedDomainEventData((TrackingToken)testTrackingToken, (DomainEventData)new GenericDomainEventEntry(testAggregateType, testAggregateId, testSequenceNumber, "eventId", (Object)Instant.now(), testPayload.getType().getName(), testPayload.getType().getRevision(), (Object)testPayload, (Object)this.serializer.serialize((Object)MetaData.emptyInstance(), String.class)));
        InitialEventRepresentation testRepresentation = new InitialEventRepresentation((EventData)testEventData, this.serializer);
        List result = this.upcaster.upcast(Stream.of(testRepresentation)).collect(Collectors.toList());
        Assertions.assertFalse((boolean)result.isEmpty());
        IntermediateEventRepresentation firstEventResult = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertEquals((Object)testAggregateType, firstEventResult.getAggregateType().get());
        Assertions.assertEquals((Object)testAggregateId, firstEventResult.getAggregateIdentifier().get());
        Assertions.assertEquals((Object)testTrackingToken, firstEventResult.getTrackingToken().get());
        Assertions.assertEquals((Long)testSequenceNumber, (Long)((Long)firstEventResult.getSequenceNumber().get()));
        IntermediateEventRepresentation secondEventResult = (IntermediateEventRepresentation)result.get(1);
        Assertions.assertEquals((Object)testAggregateType, secondEventResult.getAggregateType().get());
        Assertions.assertEquals((Object)testAggregateId, secondEventResult.getAggregateIdentifier().get());
        Assertions.assertEquals((Object)testTrackingToken, secondEventResult.getTrackingToken().get());
        Assertions.assertEquals((Long)testSequenceNumber, (Long)((Long)secondEventResult.getSequenceNumber().get()));
        IntermediateEventRepresentation thirdEventResult = (IntermediateEventRepresentation)result.get(2);
        Assertions.assertEquals((Object)testAggregateType, thirdEventResult.getAggregateType().get());
        Assertions.assertEquals((Object)testAggregateId, thirdEventResult.getAggregateIdentifier().get());
        Assertions.assertEquals((Object)testTrackingToken, thirdEventResult.getTrackingToken().get());
        Assertions.assertEquals((Long)testSequenceNumber, (Long)((Long)thirdEventResult.getSequenceNumber().get()));
    }

    @Test
    void upcastsKnownType() {
        String expectedRevisionNumber = "1";
        Object expectedSecondAndThirdRevisionNumber = null;
        MetaData testMetaData = MetaData.with((String)"key", (Object)"value");
        GenericDomainEventMessage testEventMessage = new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)new StubDomainEvent("oldName"), (Map)testMetaData);
        TestDomainEventEntry testEventData = new TestDomainEventEntry((DomainEventMessage<?>)testEventMessage, this.serializer);
        InitialEventRepresentation testRepresentation = new InitialEventRepresentation((EventData)testEventData, this.serializer);
        List result = this.upcaster.upcast(Stream.of(testRepresentation)).collect(Collectors.toList());
        Assertions.assertFalse((boolean)result.isEmpty());
        IntermediateEventRepresentation firstResultRepresentation = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertEquals((Object)expectedRevisionNumber, (Object)firstResultRepresentation.getType().getRevision());
        Assertions.assertEquals((Object)testEventData.getEventIdentifier(), (Object)firstResultRepresentation.getMessageIdentifier());
        Assertions.assertEquals((Object)testEventData.getTimestamp(), (Object)firstResultRepresentation.getTimestamp());
        Assertions.assertEquals((Object)testMetaData, (Object)firstResultRepresentation.getMetaData().getObject());
        StubDomainEvent firstUpcastedEvent = (StubDomainEvent)this.serializer.deserialize(firstResultRepresentation.getData());
        Assertions.assertEquals((Object)this.expectedNewString, (Object)firstUpcastedEvent.getName());
        IntermediateEventRepresentation secondResultRepresentation = (IntermediateEventRepresentation)result.get(1);
        Assertions.assertEquals(expectedSecondAndThirdRevisionNumber, (Object)secondResultRepresentation.getType().getRevision());
        Assertions.assertEquals((Object)testEventData.getEventIdentifier(), (Object)secondResultRepresentation.getMessageIdentifier());
        Assertions.assertEquals((Object)testEventData.getTimestamp(), (Object)secondResultRepresentation.getTimestamp());
        Assertions.assertEquals((Object)testMetaData, (Object)secondResultRepresentation.getMetaData().getObject());
        SecondStubEvent secondUpcastedEvent = (SecondStubEvent)this.serializer.deserialize(secondResultRepresentation.getData());
        Assertions.assertEquals((Object)this.expectedNewString, (Object)secondUpcastedEvent.getName());
        Assertions.assertEquals((Integer)this.expectedNewInteger, (Integer)secondUpcastedEvent.getNumber());
        IntermediateEventRepresentation thirdResultRepresentation = (IntermediateEventRepresentation)result.get(2);
        Assertions.assertEquals(expectedSecondAndThirdRevisionNumber, (Object)thirdResultRepresentation.getType().getRevision());
        Assertions.assertEquals((Object)testEventData.getEventIdentifier(), (Object)thirdResultRepresentation.getMessageIdentifier());
        Assertions.assertEquals((Object)testEventData.getTimestamp(), (Object)thirdResultRepresentation.getTimestamp());
        Assertions.assertEquals((Object)testMetaData, (Object)thirdResultRepresentation.getMetaData().getObject());
        ThirdStubEvent thirdUpcastedEvent = (ThirdStubEvent)this.serializer.deserialize(thirdResultRepresentation.getData());
        Assertions.assertEquals((Object)this.expectedNewString, (Object)thirdUpcastedEvent.getName());
        Assertions.assertEquals((Integer)this.expectedNewInteger, (Integer)thirdUpcastedEvent.getNumber());
        Assertions.assertEquals(this.expectedNewBooleans, thirdUpcastedEvent.getTruths());
    }

    private static class StubEventMultiUpcaster
    extends EventMultiUpcaster {
        private final SerializedType targetType = new SimpleSerializedType(StubDomainEvent.class.getName(), null);
        private final String newStringValue;
        private final Integer newIntegerValue;
        private final List<Boolean> newBooleanValues;

        private StubEventMultiUpcaster(String newStringValue, Integer newIntegerValue, List<Boolean> newBooleanValues) {
            this.newStringValue = newStringValue;
            this.newIntegerValue = newIntegerValue;
            this.newBooleanValues = newBooleanValues;
        }

        protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return intermediateRepresentation.getType().equals(this.targetType);
        }

        protected Stream<IntermediateEventRepresentation> doUpcast(IntermediateEventRepresentation ir) {
            return Stream.of(ir.upcastPayload((SerializedType)new SimpleSerializedType(this.targetType.getName(), "1"), JsonNode.class, this::doUpcast), ir.upcastPayload((SerializedType)new SimpleSerializedType(SecondStubEvent.class.getName(), null), JsonNode.class, this::doUpcastTwo), ir.upcastPayload((SerializedType)new SimpleSerializedType(ThirdStubEvent.class.getName(), null), JsonNode.class, this::doUpcastThree));
        }

        private JsonNode doUpcast(JsonNode eventJsonNode) {
            if (!eventJsonNode.isObject()) {
                return eventJsonNode;
            }
            ObjectNode eventObjectNode = (ObjectNode)eventJsonNode;
            eventObjectNode.set("name", (JsonNode)new TextNode(this.newStringValue));
            return eventObjectNode;
        }

        private JsonNode doUpcastTwo(JsonNode eventJsonNode) {
            if (!eventJsonNode.isObject()) {
                return eventJsonNode;
            }
            ObjectNode eventObjectNode = (ObjectNode)eventJsonNode;
            eventObjectNode.set("name", (JsonNode)new TextNode(this.newStringValue));
            eventObjectNode.set("number", (JsonNode)new IntNode(this.newIntegerValue.intValue()));
            return eventJsonNode;
        }

        private JsonNode doUpcastThree(JsonNode eventJsonNode) {
            if (!eventJsonNode.isObject()) {
                return eventJsonNode;
            }
            ObjectNode eventObjectNode = (ObjectNode)eventJsonNode;
            eventObjectNode.set("name", (JsonNode)new TextNode(this.newStringValue));
            eventObjectNode.set("number", (JsonNode)new IntNode(this.newIntegerValue.intValue()));
            ArrayNode truthsArrayNode = eventObjectNode.withArray("truths");
            this.newBooleanValues.forEach(arg_0 -> ((ArrayNode)truthsArrayNode).add(arg_0));
            return eventJsonNode;
        }
    }
}

