/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import java.io.Serializable;
import java.util.stream.Stream;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.AbstractEventEntry;
import org.axonframework.eventhandling.EventData;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.TestSerializer;
import org.axonframework.serialization.upcasting.event.EventTypeUpcaster;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class EventTypeUpcasterTest {
    public static final String EXPECTED_PAYLOAD_TYPE = TestEvent.class.getName();
    public static final String EXPECTED_REVISION = "1";
    public static final String UPCASTED_PAYLOAD_TYPE = RenamedTestEvent.class.getName();
    public static final String UPCASTED_REVISION = "2";
    private static final String SOURCE_METHOD_NAME = "provideSerializers";
    private final EventTypeUpcaster testSubject = new EventTypeUpcaster(EXPECTED_PAYLOAD_TYPE, "1", UPCASTED_PAYLOAD_TYPE, "2");

    EventTypeUpcasterTest() {
    }

    private static Stream<Arguments> provideSerializers() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestSerializer.XSTREAM.getSerializer()}), Arguments.of((Object[])new Object[]{TestSerializer.JACKSON.getSerializer()}), Arguments.of((Object[])new Object[]{TestSerializer.JACKSON_ONLY_ACCEPT_CONSTRUCTOR_PARAMETERS.getSerializer()}));
    }

    @Test
    void upcasterBuilderFailsForNullExpectedPayloadTypeClass() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> EventTypeUpcaster.from((Class)null, (String)EXPECTED_REVISION));
    }

    @Test
    void upcasterBuilderFailsForNullExpectedPayloadType() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> EventTypeUpcaster.from((String)null, (String)EXPECTED_REVISION));
    }

    @Test
    void upcasterBuilderFailsForEmptyExpectedPayloadType() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> EventTypeUpcaster.from((String)"", (String)EXPECTED_REVISION));
    }

    @Test
    void upcasterBuilderFailsForNullUpcastedPayloadTypeClass() {
        EventTypeUpcaster.Builder testSubject = EventTypeUpcaster.from((String)EXPECTED_PAYLOAD_TYPE, (String)EXPECTED_REVISION);
        Assertions.assertThrows(AxonConfigurationException.class, () -> testSubject.to((Class)null, UPCASTED_REVISION));
    }

    @Test
    void upcasterBuilderFailsForNullUpcastedPayloadType() {
        EventTypeUpcaster.Builder testSubject = EventTypeUpcaster.from((String)EXPECTED_PAYLOAD_TYPE, (String)EXPECTED_REVISION);
        Assertions.assertThrows(AxonConfigurationException.class, () -> testSubject.to((String)null, UPCASTED_REVISION));
    }

    @Test
    void upcasterBuilderFailsForEmptyUpcastedPayloadType() {
        EventTypeUpcaster.Builder testSubject = EventTypeUpcaster.from((String)EXPECTED_PAYLOAD_TYPE, (String)EXPECTED_REVISION);
        Assertions.assertThrows(AxonConfigurationException.class, () -> testSubject.to("", UPCASTED_REVISION));
    }

    @ParameterizedTest
    @MethodSource(value={"provideSerializers"})
    void canUpcastReturnsTrueForMatchingPayloadTypeAndRevision(Serializer serializer) {
        TestEventEntry testEventData = new TestEventEntry(EXPECTED_PAYLOAD_TYPE, EXPECTED_REVISION, serializer);
        InitialEventRepresentation testRepresentation = new InitialEventRepresentation((EventData)testEventData, serializer);
        Assertions.assertTrue((boolean)this.testSubject.canUpcast((IntermediateEventRepresentation)testRepresentation));
    }

    @ParameterizedTest
    @MethodSource(value={"provideSerializers"})
    void canUpcastReturnsFalseForIncorrectPayloadType(Serializer serializer) {
        TestEventEntry testEventData = new TestEventEntry("some-non-matching-payload-type", EXPECTED_REVISION, serializer);
        InitialEventRepresentation testRepresentation = new InitialEventRepresentation((EventData)testEventData, serializer);
        Assertions.assertFalse((boolean)this.testSubject.canUpcast((IntermediateEventRepresentation)testRepresentation));
    }

    @ParameterizedTest
    @MethodSource(value={"provideSerializers"})
    void canUpcastReturnsFalseForIncorrectRevision(Serializer serializer) {
        TestEventEntry testEventData = new TestEventEntry(EXPECTED_PAYLOAD_TYPE, "some-non-matching-revision", serializer);
        InitialEventRepresentation testRepresentation = new InitialEventRepresentation((EventData)testEventData, serializer);
        Assertions.assertFalse((boolean)this.testSubject.canUpcast((IntermediateEventRepresentation)testRepresentation));
    }

    @Test
    void isExpectedPayloadType() {
        Assertions.assertTrue((boolean)this.testSubject.isExpectedPayloadType(EXPECTED_PAYLOAD_TYPE));
        Assertions.assertFalse((boolean)this.testSubject.isExpectedPayloadType(UPCASTED_PAYLOAD_TYPE));
    }

    @Test
    void isExpectedRevision() {
        Assertions.assertTrue((boolean)this.testSubject.isExpectedRevision(EXPECTED_REVISION));
        Assertions.assertFalse((boolean)this.testSubject.isExpectedRevision(UPCASTED_REVISION));
    }

    @ParameterizedTest
    @MethodSource(value={"provideSerializers"})
    void doUpcast(Serializer serializer) {
        TestEventEntry testEventData = new TestEventEntry(EXPECTED_PAYLOAD_TYPE, EXPECTED_REVISION, serializer);
        InitialEventRepresentation testRepresentation = new InitialEventRepresentation((EventData)testEventData, serializer);
        IntermediateEventRepresentation result = this.testSubject.doUpcast((IntermediateEventRepresentation)testRepresentation);
        SerializedType resultType = result.getType();
        Assertions.assertEquals((Object)UPCASTED_PAYLOAD_TYPE, (Object)resultType.getName());
        Assertions.assertEquals((Object)UPCASTED_REVISION, (Object)resultType.getRevision());
    }

    @ParameterizedTest
    @MethodSource(value={"provideSerializers"})
    void shouldDeserializeToNewType(Serializer serializer) {
        if (serializer instanceof XStreamSerializer) {
            return;
        }
        TestEventEntry testEventData = new TestEventEntry(EXPECTED_PAYLOAD_TYPE, EXPECTED_REVISION, serializer);
        InitialEventRepresentation testRepresentation = new InitialEventRepresentation((EventData)testEventData, serializer);
        IntermediateEventRepresentation result = this.testSubject.doUpcast((IntermediateEventRepresentation)testRepresentation);
        Object deserialize = serializer.deserialize(result.getData());
        Assertions.assertEquals(RenamedTestEvent.class, deserialize.getClass());
    }

    @Test
    void upcastedType() {
        SimpleSerializedType expectedType = new SimpleSerializedType(UPCASTED_PAYLOAD_TYPE, UPCASTED_REVISION);
        Assertions.assertEquals((Object)expectedType, (Object)this.testSubject.upcastedType());
    }

    private static class RenamedTestEvent
    implements Serializable {
        private String testField;

        public RenamedTestEvent() {
        }

        public RenamedTestEvent(String testField) {
            this.testField = testField;
        }

        public String getTestField() {
            return this.testField;
        }

        public void setTestField(String testField) {
            this.testField = testField;
        }
    }

    private static class TestEvent
    implements Serializable {
        private String testField;

        public TestEvent() {
        }

        public TestEvent(String testField) {
            this.testField = testField;
        }

        public String getTestField() {
            return this.testField;
        }

        public void setTestField(String testField) {
            this.testField = testField;
        }
    }

    private static class TestEventEntry
    extends AbstractEventEntry<byte[]> {
        private static final TestEvent PAYLOAD = new TestEvent("payload");
        private static final TestEvent META_DATA = new TestEvent("metadata");

        public TestEventEntry(String payloadType, String payloadRevision, Serializer serializer) {
            super("eventIdentifier", (Object)"timestamp", payloadType, payloadRevision, serializer.serialize((Object)PAYLOAD, byte[].class).getData(), serializer.serialize((Object)META_DATA, byte[].class).getData());
        }
    }
}

