/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.TestSerializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.serialization.upcasting.event.SingleEventUpcaster;
import org.axonframework.serialization.upcasting.event.UpcastedEventRepresentation;
import org.axonframework.utils.TestDomainEventEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class IntermediateRepresentationTest {
    private static final Serializer serializer = TestSerializer.XSTREAM.getSerializer();

    IntermediateRepresentationTest() {
    }

    @Test
    public void canConvertDataTo() {
        TestDomainEventEntry eventData = new TestDomainEventEntry((DomainEventMessage<?>)new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)"someString"), serializer);
        Serializer serializer = (Serializer)Mockito.mock(Serializer.class);
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)serializer.getConverter()).thenReturn((Object)converter);
        Mockito.when((Object)converter.canConvert((Class)Mockito.any(), (Class)Mockito.eq(String.class))).thenReturn((Object)true);
        InitialEventRepresentation input = new InitialEventRepresentation((EventData)eventData, serializer);
        EventUpcasterChain eventUpcasterChain = new EventUpcasterChain(new EventUpcaster[]{new MyEventUpcaster()});
        List result = eventUpcasterChain.upcast(Stream.of(input)).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((boolean)input.canConvertDataTo(String.class));
        Assertions.assertTrue((boolean)((IntermediateEventRepresentation)result.get(0)).canConvertDataTo(String.class));
        ((Converter)Mockito.verify((Object)converter)).canConvert(String.class, String.class);
    }

    private static class MyEventUpcaster
    extends SingleEventUpcaster {
        private MyEventUpcaster() {
        }

        protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return true;
        }

        protected IntermediateEventRepresentation doUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return new UpcastedEventRepresentation(intermediateRepresentation.getType(), intermediateRepresentation, Function.identity(), Function.identity(), Object.class, serializer.getConverter());
        }
    }
}

