/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.xml;

import java.util.Arrays;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.TestSerializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GapAwareTrackingTokenConverterTest {
    private static final GapAwareTrackingToken TEST_TOKEN = GapAwareTrackingToken.newInstance((long)Long.MAX_VALUE, Arrays.asList(0L, 1L));
    public static final String TOKEN_CLASS_NAME = "org.axonframework.eventhandling.GapAwareTrackingToken";
    private static final String REFLECTIVE_XML_FORMAT = "<org.axonframework.eventhandling.GapAwareTrackingToken><index>9223372036854775807</index><gaps class=\"java.util.concurrent.ConcurrentSkipListSet\"><m class=\"java.util.concurrent.ConcurrentSkipListMap\" serialization=\"custom\"><unserializable-parents/><java.util.concurrent.ConcurrentSkipListMap><default/><long>0</long><boolean>true</boolean><long>1</long><boolean>true</boolean><null/></java.util.concurrent.ConcurrentSkipListMap></m></gaps></org.axonframework.eventhandling.GapAwareTrackingToken>";
    private static final String CUSTOM_CONVERTER_XML_FORMAT = "<org.axonframework.eventhandling.GapAwareTrackingToken><index>9223372036854775807</index><gaps><long>0</long><long>1</long></gaps></org.axonframework.eventhandling.GapAwareTrackingToken>";
    private final XStreamSerializer serializer = (XStreamSerializer)TestSerializer.XSTREAM.getSerializer();

    GapAwareTrackingTokenConverterTest() {
    }

    @Test
    void canDeserializeReflectiveFormat() {
        SimpleSerializedObject reflectivelySerializedToken = new SimpleSerializedObject((Object)REFLECTIVE_XML_FORMAT, String.class, TOKEN_CLASS_NAME, null);
        GapAwareTrackingToken result = (GapAwareTrackingToken)this.serializer.deserialize((SerializedObject)reflectivelySerializedToken);
        Assertions.assertEquals((Object)TEST_TOKEN, (Object)result);
    }

    @Test
    void canDeserializeCustomConverterFormat() {
        SimpleSerializedObject reflectivelySerializedToken = new SimpleSerializedObject((Object)CUSTOM_CONVERTER_XML_FORMAT, String.class, TOKEN_CLASS_NAME, null);
        GapAwareTrackingToken result = (GapAwareTrackingToken)this.serializer.deserialize((SerializedObject)reflectivelySerializedToken);
        Assertions.assertEquals((Object)TEST_TOKEN, (Object)result);
    }
}

