/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class IntermediateSpanFactoryTest<BI, SI> {
    private final TestSpanFactory spanFactory = new TestSpanFactory();

    protected abstract BI createBuilder(SpanFactory var1);

    protected abstract SI createFactoryBasedOnBuilder(BI var1);

    @Test
    void cannotSetNullSpanFactory() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.createBuilder(null));
    }

    protected void test(Function<BI, BI> builderAdditions, Function<SI, Span> invocation, ExpectedSpan definition) {
        this.test(new SpanFactoryTestDefinition(builderAdditions, invocation, definition));
    }

    protected void test(Function<SI, Span> invocation, ExpectedSpan definition) {
        this.test(new SpanFactoryTestDefinition(builder -> builder, invocation, definition));
    }

    protected void test(SpanFactoryTestDefinition testDefinition) {
        BI builder = this.createBuilder(this.spanFactory);
        builder = testDefinition.getBuilderAdditions().apply(builder);
        SI spanFactory = this.createFactoryBasedOnBuilder(builder);
        Span span = testDefinition.getInvocation().apply(spanFactory);
        testDefinition.getExpectedSpan().assertSpan(span);
    }

    protected <M extends Message<?>> void testContextPropagation(M message, BiConsumer<SI, M> invocation) {
        SI siSpanFactory = this.createFactoryBasedOnBuilder(this.createBuilder(this.spanFactory));
        this.spanFactory.createRootTrace(() -> "dummy trace").run(() -> {
            invocation.accept(siSpanFactory, message);
            this.spanFactory.verifySpanPropagated("dummy trace", message);
        });
    }

    protected ExpectedSpan expectedSpan(String expectedName, TestSpanFactory.TestSpanType expectedType) {
        return new ExpectedSpan(expectedName, expectedType);
    }

    protected ExpectedSpan noOpSpan() {
        return new NoOpExpectedSpan();
    }

    protected class NoOpExpectedSpan
    extends ExpectedSpan {
        private NoOpExpectedSpan() {
            super("NoOpSpan", TestSpanFactory.TestSpanType.ROOT);
        }

        @Override
        public void assertSpan(Span span) {
            Assertions.assertSame((Object)NoOpSpanFactory.NoOpSpan.INSTANCE, (Object)span);
        }
    }

    protected static class ExpectedSpan {
        private final String name;
        private final TestSpanFactory.TestSpanType type;
        private final Map<String, String> attributes = new HashMap<String, String>();
        private Message<?> message = null;

        private ExpectedSpan(String name, TestSpanFactory.TestSpanType type) {
            this.name = name;
            this.type = type;
        }

        public ExpectedSpan expectAttribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public ExpectedSpan withMessage(Message<?> message) {
            this.message = message;
            return this;
        }

        public void assertSpan(Span span) {
            if (span instanceof TestSpanFactory.TestSpan) {
                this.assertSpan((TestSpanFactory.TestSpan)span);
            } else {
                Assertions.fail((String)("Expected a TestSpan, but got " + span.getClass().getSimpleName()));
            }
        }

        private void assertSpan(TestSpanFactory.TestSpan span) {
            Assertions.assertEquals((Object)this.name, (Object)span.getName());
            Assertions.assertEquals((Object)((Object)this.type), (Object)((Object)span.getType()));
            this.attributes.forEach((key, value) -> Assertions.assertEquals((Object)value, (Object)span.getAttribute((String)key)));
            if (this.message != null) {
                Assertions.assertSame(this.message, span.getMessage());
            }
        }
    }

    protected class SpanFactoryTestDefinition {
        private final Function<BI, BI> builderAdditions;
        private final Function<SI, Span> invocation;
        private final ExpectedSpan expectedSpan;

        private SpanFactoryTestDefinition(Function<BI, BI> builderAdditions, Function<SI, Span> invocation, ExpectedSpan expectedSpan) {
            this.builderAdditions = builderAdditions;
            this.invocation = invocation;
            this.expectedSpan = expectedSpan;
        }

        public Function<BI, BI> getBuilderAdditions() {
            return this.builderAdditions;
        }

        public Function<SI, Span> getInvocation() {
            return this.invocation;
        }

        public ExpectedSpan getExpectedSpan() {
            return this.expectedSpan;
        }
    }
}

