/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.tracing.LoggingSpanFactory;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LoggingSpanFactoryTest {
    LoggingSpanFactoryTest() {
    }

    @Test
    void createRootTraceReturnsNoOpSpan() {
        Span trace = LoggingSpanFactory.INSTANCE.createRootTrace(() -> "Trace");
        Assertions.assertNotNull((Object)trace);
    }

    @Test
    void createHandlerSpanReturnsNoOpSpan() {
        Span trace = LoggingSpanFactory.INSTANCE.createHandlerSpan(() -> "Trace", (Message)new GenericEventMessage((Object)"payload"), true, new Message[0]);
        Assertions.assertNotNull((Object)trace);
    }

    @Test
    void createDispatchSpanReturnsNoOpSpan() {
        Span trace = LoggingSpanFactory.INSTANCE.createDispatchSpan(() -> "Trace", (Message)new GenericEventMessage((Object)"payload"), new Message[0]);
        Assertions.assertNotNull((Object)trace);
    }

    @Test
    void createInternalSpanWithMessageReturnsNoOpSpan() {
        Span trace = LoggingSpanFactory.INSTANCE.createInternalSpan(() -> "Trace", (Message)new GenericEventMessage((Object)"payload"));
        Assertions.assertNotNull((Object)trace);
    }

    @Test
    void createInternalSpanWithoutMessageReturnsNoOpSpan() {
        Span trace = LoggingSpanFactory.INSTANCE.createInternalSpan(() -> "Trace");
        Assertions.assertNotNull((Object)trace);
    }

    @Test
    void propagateContextReturnsOriginal() {
        GenericEventMessage message = new GenericEventMessage((Object)"payload");
        GenericEventMessage result = (GenericEventMessage)NoOpSpanFactory.INSTANCE.propagateContext((Message)message);
        Assertions.assertSame((Object)message, (Object)result);
    }

    @Test
    void internalSpanCanBeStartedAndEnded() {
        Assertions.assertDoesNotThrow(() -> {
            Span trace = LoggingSpanFactory.INSTANCE.createInternalSpan(() -> "Trace");
            trace.start().recordException((Throwable)new RuntimeException("My test exception")).end();
        });
    }

    @Test
    void internalSpanCanBeStartedAndEndedWithUnitOfWorkActive() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"My command");
        DefaultUnitOfWork uow = new DefaultUnitOfWork((Message)command);
        uow.start();
        Assertions.assertDoesNotThrow(() -> {
            Span trace = LoggingSpanFactory.INSTANCE.createInternalSpan(() -> "Trace");
            trace.start().recordException((Throwable)new RuntimeException("My test exception")).end();
            uow.commit();
        });
    }

    @Test
    void handlingSpanCanBeStartedAndEnded() {
        GenericEventMessage message = new GenericEventMessage((Object)"payload");
        Assertions.assertDoesNotThrow(() -> {
            Span trace = LoggingSpanFactory.INSTANCE.createHandlerSpan(() -> "Trace", (Message)message, true, new Message[0]);
            trace.start().recordException((Throwable)new RuntimeException("My test exception")).end();
        });
    }

    @Test
    void rootSpanCanBeStartedAndEnded() {
        Assertions.assertDoesNotThrow(() -> {
            Span trace = LoggingSpanFactory.INSTANCE.createRootTrace(() -> "Trace");
            trace.start().recordException((Throwable)new RuntimeException("My test exception")).end();
        });
    }

    @Test
    void dispatchSpanCanBeStartedAndEnded() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"My command");
        Assertions.assertDoesNotThrow(() -> {
            Span trace = LoggingSpanFactory.INSTANCE.createDispatchSpan(() -> "Trace", (Message)command, new Message[0]);
            trace.start().recordException((Throwable)new RuntimeException("My test exception")).end();
        });
    }

    @Test
    void dispatchSpanCanBeStartedAndEndedWhileUnitOfWorkActive() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"My command");
        DefaultUnitOfWork uow = new DefaultUnitOfWork((Message)command);
        uow.start();
        GenericEventMessage message = new GenericEventMessage((Object)"payload");
        Assertions.assertDoesNotThrow(() -> {
            Span trace = LoggingSpanFactory.INSTANCE.createDispatchSpan(() -> "Trace", (Message)message, new Message[0]);
            trace.start().recordException((Throwable)new RuntimeException("My test exception")).end();
        });
        uow.commit();
    }

    @Test
    void internalSpanWithMessageCanBeStartedAndEnded() {
        GenericEventMessage message = new GenericEventMessage((Object)"payload");
        Assertions.assertDoesNotThrow(() -> {
            Span trace = LoggingSpanFactory.INSTANCE.createInternalSpan(() -> "Trace", (Message)message);
            trace.start().recordException((Throwable)new RuntimeException("My test exception")).end();
        });
    }

    @Test
    void internalSpanWithMessageCanBeStartedAndEndedWhileUnitOfWorkActive() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"My command");
        DefaultUnitOfWork uow = new DefaultUnitOfWork((Message)command);
        uow.start();
        GenericEventMessage message = new GenericEventMessage((Object)"payload");
        Assertions.assertDoesNotThrow(() -> {
            Span trace = LoggingSpanFactory.INSTANCE.createInternalSpan(() -> "Trace", (Message)message);
            trace.start().recordException((Throwable)new RuntimeException("My test exception")).end();
        });
        uow.commit();
    }
}

