/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NoOpSpanFactoryTest {
    NoOpSpanFactoryTest() {
    }

    @Test
    void createRootTraceReturnsNoOpSpan() {
        Span trace = NoOpSpanFactory.INSTANCE.createRootTrace(() -> "Trace");
        Assertions.assertTrue((boolean)(trace instanceof NoOpSpanFactory.NoOpSpan));
    }

    @Test
    void createHandlerSpanReturnsNoOpSpan() {
        Span trace = NoOpSpanFactory.INSTANCE.createHandlerSpan(() -> "Trace", (Message)new GenericEventMessage((Object)"payload"), true, new Message[0]);
        Assertions.assertTrue((boolean)(trace instanceof NoOpSpanFactory.NoOpSpan));
    }

    @Test
    void createDispatchSpanReturnsNoOpSpan() {
        Span trace = NoOpSpanFactory.INSTANCE.createDispatchSpan(() -> "Trace", (Message)new GenericEventMessage((Object)"payload"), new Message[0]);
        Assertions.assertTrue((boolean)(trace instanceof NoOpSpanFactory.NoOpSpan));
    }

    @Test
    void createInternalSpanWithMessageReturnsNoOpSpan() {
        Span trace = NoOpSpanFactory.INSTANCE.createInternalSpan(() -> "Trace", (Message)new GenericEventMessage((Object)"payload"));
        Assertions.assertTrue((boolean)(trace instanceof NoOpSpanFactory.NoOpSpan));
    }

    @Test
    void createInternalSpanWithoutMessageReturnsNoOpSpan() {
        Span trace = NoOpSpanFactory.INSTANCE.createInternalSpan(() -> "Trace");
        Assertions.assertTrue((boolean)(trace instanceof NoOpSpanFactory.NoOpSpan));
    }

    @Test
    void propagateContextReturnsOriginal() {
        GenericEventMessage message = new GenericEventMessage((Object)"payload");
        GenericEventMessage result = (GenericEventMessage)NoOpSpanFactory.INSTANCE.propagateContext((Message)message);
        Assertions.assertSame((Object)message, (Object)result);
    }

    @Test
    void noOpSpanReturnsSelfOnStart() {
        NoOpSpanFactory.NoOpSpan noOpSpan = new NoOpSpanFactory.NoOpSpan();
        Assertions.assertSame((Object)noOpSpan, (Object)noOpSpan.start());
    }

    @Test
    void noOpSpanReturnsSelfOnRecordException() {
        NoOpSpanFactory.NoOpSpan noOpSpan = new NoOpSpanFactory.NoOpSpan();
        Assertions.assertSame((Object)noOpSpan, (Object)noOpSpan.recordException((Throwable)new RuntimeException("")));
    }
}

