/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.tracing.SpanUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SpanUtilsTest {
    SpanUtilsTest() {
    }

    @Test
    void determineMessageNameForEvent() {
        GenericEventMessage message = new GenericEventMessage((Object)"MyPayload");
        Assertions.assertEquals((Object)"String", (Object)SpanUtils.determineMessageName((Message)message));
    }

    @Test
    void determineMessageNameForQueryWithoutName() {
        GenericQueryMessage message = new GenericQueryMessage((Object)"MyPayload", ResponseTypes.instanceOf(String.class));
        Assertions.assertEquals((Object)"String", (Object)SpanUtils.determineMessageName((Message)message));
    }

    @Test
    void determineMessageNameForQueryWithName() {
        GenericQueryMessage message = new GenericQueryMessage((Object)"MyPayload", "SuperString", ResponseTypes.instanceOf(String.class));
        Assertions.assertEquals((Object)"SuperString", (Object)SpanUtils.determineMessageName((Message)message));
    }

    @Test
    void determineMessageNameForQueryWithSameName() {
        GenericQueryMessage message = new GenericQueryMessage((Object)"MyPayload", "java.lang.String", ResponseTypes.instanceOf(String.class));
        Assertions.assertEquals((Object)"String", (Object)SpanUtils.determineMessageName((Message)message));
    }

    @Test
    void determineMessageNameForCommandWithoutName() {
        GenericCommandMessage message = new GenericCommandMessage((Object)"MyPayload");
        Assertions.assertEquals((Object)"String", (Object)SpanUtils.determineMessageName((Message)message));
    }

    @Test
    void determineMessageNameForCommandWithName() {
        GenericCommandMessage message = new GenericCommandMessage((Message)new GenericCommandMessage((Object)"MyPayload"), "SuperCommand");
        Assertions.assertEquals((Object)"SuperCommand", (Object)SpanUtils.determineMessageName((Message)message));
    }

    @Test
    void determineMessageNameForDeadlineWithoutPayload() {
        GenericDeadlineMessage message = new GenericDeadlineMessage("myDeadlineName");
        Assertions.assertEquals((Object)"myDeadlineName", (Object)SpanUtils.determineMessageName((Message)message));
    }

    @Test
    void determineMessageNameForDeadlineWithPayload() {
        GenericDeadlineMessage message = new GenericDeadlineMessage("myDeadlineName", (Object)"MyPayload");
        Assertions.assertEquals((Object)"myDeadlineName,String", (Object)SpanUtils.determineMessageName((Message)message));
    }
}

