/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import org.axonframework.updates.LoggingUpdateCheckerReporter;
import org.axonframework.updates.api.Artifact;
import org.axonframework.updates.api.ArtifactAvailableUpgrade;
import org.axonframework.updates.api.DetectedVulnerability;
import org.axonframework.updates.api.DetectedVulnerabilitySeverity;
import org.axonframework.updates.api.UpdateCheckRequest;
import org.axonframework.updates.api.UpdateCheckResponse;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
class LoggingUpdateCheckerReporterTest {
    private LoggingUpdateCheckerReporter reporter;
    private Logger originalLogger;
    private Logger mockLogger;
    private final UpdateCheckRequest sampleRequest = new UpdateCheckRequest("my-machine-id-1234", "my-instance-id-5678", "Linux", "6", "x64", "21.0.2", "Oracle", "none", Arrays.asList(new Artifact("org.axonframework", "axon-framework", "5.0.1"), new Artifact("org.axonframework", "axon-messaging", "5.0.0"), new Artifact("io.axoniq.console", "framework-client-spring-boot-starter", "2.1.10")));

    LoggingUpdateCheckerReporterTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.reporter = new LoggingUpdateCheckerReporter();
        Field loggerField = LoggingUpdateCheckerReporter.class.getDeclaredField("logger");
        loggerField.setAccessible(true);
        this.originalLogger = (Logger)loggerField.get(null);
        this.mockLogger = (Logger)Mockito.spy((Object)LoggerFactory.getLogger(LoggingUpdateCheckerReporter.class));
        loggerField.set(null, this.mockLogger);
    }

    @AfterEach
    void tearDown() throws Exception {
        Field loggerField = LoggingUpdateCheckerReporter.class.getDeclaredField("logger");
        loggerField.setAccessible(true);
        loggerField.set(null, this.originalLogger);
    }

    @Test
    void logsCorrectlyWithOnlyUpgrades() {
        UpdateCheckResponse updateCheckResponse = new UpdateCheckResponse(500, Arrays.asList(new ArtifactAvailableUpgrade("org.axonframework", "axon-framework", "5.2.0"), new ArtifactAvailableUpgrade("org.axonframework", "axon-messaging", "5.1.0"), new ArtifactAvailableUpgrade("io.axoniq.console", "framework-client-spring-boot-starter", "2.2.0")), Collections.emptyList());
        this.reporter.report(this.sampleRequest, updateCheckResponse);
        ((Logger)Mockito.verify((Object)this.mockLogger)).info("AxonIQ has found the following dependency upgrade(s):");
        ((Logger)Mockito.verify((Object)this.mockLogger)).info("{} {} -> {}", new Object[]{"org.axonframework:axon-framework........................", "5.0.1 ", "5.2.0"});
        ((Logger)Mockito.verify((Object)this.mockLogger)).info("{} {} -> {}", new Object[]{"org.axonframework:axon-messaging........................", "5.0.0 ", "5.1.0"});
        ((Logger)Mockito.verify((Object)this.mockLogger)).info("{} {} -> {}", new Object[]{"io.axoniq.console:framework-client-spring-boot-starter..", "2.1.10", "2.2.0"});
        ((Logger)Mockito.verify((Object)this.mockLogger)).info("No vulnerabilities have been found in your Axon libraries.");
    }

    @Test
    void logsCorrectlyWithOnlyVulnerabilities() {
        UpdateCheckResponse updateCheckResponse = new UpdateCheckResponse(500, Collections.emptyList(), Arrays.asList(new DetectedVulnerability("org.axonframework", "axon-framework", DetectedVulnerabilitySeverity.HIGH, "5.0.1", "CVE-2025-1234: Security vulnerability in message handling"), new DetectedVulnerability("org.axonframework", "axon-messaging", DetectedVulnerabilitySeverity.CRITICAL, "5.0.0", "CVE-2025-67890: Remote code execution vulnerability"), new DetectedVulnerability("io.axoniq.console", "framework-client-spring-boot-starter", DetectedVulnerabilitySeverity.MEDIUM, "2.1.10", "CVE-2025-54321: Information disclosure vulnerability")));
        this.reporter.report(this.sampleRequest, updateCheckResponse);
        ((Logger)Mockito.verify((Object)this.mockLogger)).error("AxonIQ has found the following vulnerabilities in your Axon libraries:");
        ((Logger)Mockito.verify((Object)this.mockLogger)).error("[{}] {} [Fixed in: {}] Description: {}", new Object[]{"HIGH    ", "org.axonframework:axon-framework........................", "5.0.1 ", "CVE-2025-1234: Security vulnerability in message handling"});
        ((Logger)Mockito.verify((Object)this.mockLogger)).error("[{}] {} [Fixed in: {}] Description: {}", new Object[]{"CRITICAL", "org.axonframework:axon-messaging........................", "5.0.0 ", "CVE-2025-67890: Remote code execution vulnerability"});
        ((Logger)Mockito.verify((Object)this.mockLogger)).error("[{}] {} [Fixed in: {}] Description: {}", new Object[]{"MEDIUM  ", "io.axoniq.console:framework-client-spring-boot-starter..", "2.1.10", "CVE-2025-54321: Information disclosure vulnerability"});
    }

    @Test
    void logsCorrectlyWithBothUpgradesAndVulnerabilities() {
        UpdateCheckResponse updateCheckResponse = new UpdateCheckResponse(500, Arrays.asList(new ArtifactAvailableUpgrade("org.axonframework", "axon-framework", "5.2.0"), new ArtifactAvailableUpgrade("org.axonframework", "axon-messaging", "5.1.0")), Arrays.asList(new DetectedVulnerability("org.axonframework", "axon-framework", DetectedVulnerabilitySeverity.HIGH, "5.0.1", "CVE-2025-1234: Security vulnerability in message handling")));
        this.reporter.report(this.sampleRequest, updateCheckResponse);
        ((Logger)Mockito.verify((Object)this.mockLogger)).error("AxonIQ has found the following vulnerabilities in your Axon libraries:");
        ((Logger)Mockito.verify((Object)this.mockLogger)).error("[{}] {} [Fixed in: {}] Description: {}", new Object[]{"HIGH", "org.axonframework:axon-framework..", "5.0.1", "CVE-2025-1234: Security vulnerability in message handling"});
        ((Logger)Mockito.verify((Object)this.mockLogger)).info("Additionally, AxonIQ has found an upgrade(s) for your Axon libraries:");
        ((Logger)Mockito.verify((Object)this.mockLogger)).info("{} {} -> {}", new Object[]{"org.axonframework:axon-framework........................", "5.0.1 ", "5.2.0"});
        ((Logger)Mockito.verify((Object)this.mockLogger)).info("{} {} -> {}", new Object[]{"org.axonframework:axon-messaging........................", "5.0.0 ", "5.1.0"});
    }
}

