/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import java.util.Arrays;
import java.util.Collections;
import org.axonframework.updates.api.Artifact;
import org.axonframework.updates.api.UpdateCheckRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UpdateCheckRequestTest {
    UpdateCheckRequestTest() {
    }

    @Test
    void toQueryString() {
        UpdateCheckRequest request = new UpdateCheckRequest("machine-1234", "instance-5678", "Linux", "6.11.0-26-generic", "amd64", "17.0.2", "AdoptOpenJDK", "1.8.22", Arrays.asList(new Artifact("org.axonframework", "axon-core", "5.0.0"), new Artifact("org.axonframework.something", "axon-something", "5.0.0"), new Artifact("org.axonframework.extensions", "axon-ext-bland", "5.0.0"), new Artifact("org.axonframework.extensions.kafka", "axon-ext-kafka", "5.0.0"), new Artifact("io.axoniq", "top-level-axoniq", "5.0.0"), new Artifact("io.axoniq.sub", "sub-level-axoniq", "5.0.0"), new Artifact("org.example", "example-lib", "1.2.3")));
        String queryString = request.toQueryString();
        Assertions.assertTrue((boolean)queryString.contains("os=Linux%3B+6.11.0-26-generic%3B+amd64"));
        Assertions.assertTrue((boolean)queryString.contains("java=17.0.2%3B+AdoptOpenJDK"));
        Assertions.assertTrue((boolean)queryString.contains("kotlin=1.8.22"));
        Assertions.assertTrue((boolean)queryString.contains("lib-fw.axon-core=5.0.0"), (String)queryString);
        Assertions.assertTrue((boolean)queryString.contains("lib-fw.something.axon-something=5.0.0"), (String)queryString);
        Assertions.assertTrue((boolean)queryString.contains("lib-ext.axon-ext-bland=5.0.0"), (String)queryString);
        Assertions.assertTrue((boolean)queryString.contains("lib-ext.kafka.axon-ext-kafka=5.0.0"), (String)queryString);
        Assertions.assertTrue((boolean)queryString.contains("lib-iq.top-level-axoniq=5.0.0"), (String)queryString);
        Assertions.assertTrue((boolean)queryString.contains("lib-iq.sub.sub-level-axoniq=5.0.0"), (String)queryString);
        Assertions.assertTrue((boolean)queryString.contains("lib-org.example.example-lib=1.2.3"));
    }

    @Test
    void toUserAgent() {
        UpdateCheckRequest request = new UpdateCheckRequest("machine-1234", "instance-5678", "Linux", "6.11.0-26-generic", "amd64", "17.0.2", "AdoptOpenJDK", "1.8.22", Collections.singletonList(new Artifact("org.axonframework", "axon-messaging", "5.0.1")));
        String userAgent = request.toUserAgent();
        Assertions.assertEquals((Object)"AxonIQ UpdateChecker/5.0.1 (Java 17.0.2 AdoptOpenJDK; Linux; 6.11.0-26-generic; amd64)", (Object)userAgent);
    }
}

