/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.awaitility.Awaitility;
import org.axonframework.updates.UpdateChecker;
import org.axonframework.updates.UpdateCheckerHttpClient;
import org.axonframework.updates.UpdateCheckerReporter;
import org.axonframework.updates.api.UpdateCheckRequest;
import org.axonframework.updates.api.UpdateCheckResponse;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class UpdateCheckerTest {
    @Mock
    private UpdateCheckerHttpClient httpClient;
    @Mock
    private UpdateCheckerReporter reporter;
    private UpdateChecker updateChecker;

    UpdateCheckerTest() {
    }

    @BeforeEach
    void setUp() {
        this.updateChecker = new UpdateChecker(this.httpClient, this.reporter);
    }

    @AfterEach
    void tearDown() {
        this.updateChecker.stop();
    }

    @Test
    void shouldExecuteRepeatedly() {
        UpdateCheckResponse response1 = new UpdateCheckResponse(1, Collections.emptyList(), Collections.emptyList());
        UpdateCheckResponse response2 = new UpdateCheckResponse(2, Collections.emptyList(), Collections.emptyList());
        Mockito.when((Object)this.httpClient.sendRequest((UpdateCheckRequest)Mockito.any(), Mockito.eq((boolean)true))).thenReturn(Optional.of(response1));
        Mockito.when((Object)this.httpClient.sendRequest((UpdateCheckRequest)Mockito.any(), Mockito.eq((boolean)false))).thenReturn(Optional.of(response2));
        this.updateChecker.start();
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> ((UpdateCheckerReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).report((UpdateCheckRequest)Mockito.any(), (UpdateCheckResponse)Mockito.eq((Object)response1)));
        Awaitility.await().atMost(Duration.ofSeconds(3L)).untilAsserted(() -> ((UpdateCheckerReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).report((UpdateCheckRequest)Mockito.any(), (UpdateCheckResponse)Mockito.eq((Object)response2)));
        this.updateChecker.stop();
    }

    @Test
    void shouldHandleErrorsWithExponentialBackoff() {
        UpdateCheckResponse successResponse = new UpdateCheckResponse(1, Collections.emptyList(), Collections.emptyList());
        AtomicInteger requestCount = new AtomicInteger();
        Mockito.when((Object)this.httpClient.sendRequest((UpdateCheckRequest)Mockito.any(), Mockito.anyBoolean())).thenAnswer(invocation -> {
            int count = requestCount.incrementAndGet();
            if (count < 4) {
                return Optional.empty();
            }
            return Optional.of(successResponse);
        });
        this.updateChecker.start();
        Awaitility.await().atMost(Duration.ofSeconds(30L)).untilAsserted(() -> ((UpdateCheckerHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)3))).sendRequest((UpdateCheckRequest)Mockito.any(), Mockito.anyBoolean()));
        this.updateChecker.stop();
    }

    @Test
    void shouldHandleExceptionsGracefully() {
        UpdateCheckResponse successResponse = new UpdateCheckResponse(1, Collections.emptyList(), Collections.emptyList());
        AtomicInteger requestCount = new AtomicInteger();
        Mockito.when((Object)this.httpClient.sendRequest((UpdateCheckRequest)Mockito.any(), Mockito.anyBoolean())).thenAnswer(invocation -> {
            int count = requestCount.incrementAndGet();
            if (count == 1) {
                throw new RuntimeException("Test exception");
            }
            return Optional.of(successResponse);
        });
        this.updateChecker.start();
        Awaitility.await().atMost(Duration.ofSeconds(6L)).untilAsserted(() -> ((UpdateCheckerHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).sendRequest((UpdateCheckRequest)Mockito.any(), Mockito.anyBoolean()));
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> ((UpdateCheckerReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).report((UpdateCheckRequest)Mockito.any(), (UpdateCheckResponse)Mockito.any()));
        this.updateChecker.stop();
    }
}

