/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import org.axonframework.updates.api.ArtifactAvailableUpgrade;
import org.axonframework.updates.api.DetectedVulnerability;
import org.axonframework.updates.api.DetectedVulnerabilitySeverity;
import org.axonframework.updates.api.UpdateCheckResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UsageResponseTest {
    UsageResponseTest() {
    }

    @Test
    void parsesTheResponseCorrectly() {
        String body = "cd=12345\nupd=org.axonframework:axon-messaging:5.0.1\nupd=org.axonframework:axon-modelling:5.0.1\nupd=io.axoniq.console:console-framework-client-spring-boot-starter:2.1.0\nvul=org.axonframework:axon-modelling:5.0.1:MEDIUM:\"The EntityModel can be abused as a Denial of Service attack vector: https://axoniq.io/vulnerabilities/2023-01-01\"\nvul=org.axonframework:axon-messaging:5.0.1:HIGH:\"The Jackson version supplied by default has an NSA-backdoor built int. Please upgrade Jackson to version 1337.0\"";
        UpdateCheckResponse response = UpdateCheckResponse.fromRequest((String)body);
        Assertions.assertEquals((int)12345, (int)response.checkInterval());
        Assertions.assertEquals((int)3, (int)response.upgrades().size());
        Assertions.assertEquals((Object)"org.axonframework", (Object)((ArtifactAvailableUpgrade)response.upgrades().get(0)).groupId());
        Assertions.assertEquals((Object)"axon-messaging", (Object)((ArtifactAvailableUpgrade)response.upgrades().get(0)).artifactId());
        Assertions.assertEquals((Object)"5.0.1", (Object)((ArtifactAvailableUpgrade)response.upgrades().get(0)).latestVersion());
        Assertions.assertEquals((Object)"org.axonframework", (Object)((ArtifactAvailableUpgrade)response.upgrades().get(1)).groupId());
        Assertions.assertEquals((Object)"axon-modelling", (Object)((ArtifactAvailableUpgrade)response.upgrades().get(1)).artifactId());
        Assertions.assertEquals((Object)"5.0.1", (Object)((ArtifactAvailableUpgrade)response.upgrades().get(1)).latestVersion());
        Assertions.assertEquals((Object)"io.axoniq.console", (Object)((ArtifactAvailableUpgrade)response.upgrades().get(2)).groupId());
        Assertions.assertEquals((Object)"console-framework-client-spring-boot-starter", (Object)((ArtifactAvailableUpgrade)response.upgrades().get(2)).artifactId());
        Assertions.assertEquals((Object)"2.1.0", (Object)((ArtifactAvailableUpgrade)response.upgrades().get(2)).latestVersion());
        Assertions.assertEquals((int)2, (int)response.vulnerabilities().size());
        Assertions.assertEquals((Object)"org.axonframework", (Object)((DetectedVulnerability)response.vulnerabilities().get(0)).groupId());
        Assertions.assertEquals((Object)"axon-modelling", (Object)((DetectedVulnerability)response.vulnerabilities().get(0)).artifactId());
        Assertions.assertEquals((Object)"5.0.1", (Object)((DetectedVulnerability)response.vulnerabilities().get(0)).fixVersion());
        Assertions.assertEquals((Object)DetectedVulnerabilitySeverity.MEDIUM, (Object)((DetectedVulnerability)response.vulnerabilities().get(0)).severity());
        Assertions.assertEquals((Object)"The EntityModel can be abused as a Denial of Service attack vector: https://axoniq.io/vulnerabilities/2023-01-01", (Object)((DetectedVulnerability)response.vulnerabilities().get(0)).description());
        Assertions.assertEquals((Object)"org.axonframework", (Object)((DetectedVulnerability)response.vulnerabilities().get(1)).groupId());
        Assertions.assertEquals((Object)"axon-messaging", (Object)((DetectedVulnerability)response.vulnerabilities().get(1)).artifactId());
        Assertions.assertEquals((Object)"5.0.1", (Object)((DetectedVulnerability)response.vulnerabilities().get(1)).fixVersion());
        Assertions.assertEquals((Object)DetectedVulnerabilitySeverity.HIGH, (Object)((DetectedVulnerability)response.vulnerabilities().get(1)).severity());
        Assertions.assertEquals((Object)"The Jackson version supplied by default has an NSA-backdoor built int. Please upgrade Jackson to version 1337.0", (Object)((DetectedVulnerability)response.vulnerabilities().get(1)).description());
    }
}

