/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.configuration;

import org.axonframework.updates.configuration.CommandLineUsagePropertyProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CommandLineUsagePropertyProviderTest {
    private final CommandLineUsagePropertyProvider provider = new CommandLineUsagePropertyProvider();

    CommandLineUsagePropertyProviderTest() {
    }

    @AfterEach
    void cleanup() {
        System.clearProperty("axoniq.update-checker.disabled");
        System.clearProperty("axoniq.usage.url");
    }

    @Test
    void getDisabledTrue() {
        System.setProperty("axoniq.update-checker.disabled", "true");
        Assertions.assertTrue((boolean)this.provider.getDisabled());
    }

    @Test
    void getDisabledFalse() {
        System.setProperty("axoniq.update-checker.disabled", "false");
        Assertions.assertFalse((boolean)this.provider.getDisabled());
    }

    @Test
    void getDisabledNullWhenUnset() {
        Assertions.assertNull((Object)this.provider.getDisabled());
    }

    @Test
    void getUrl() {
        System.setProperty("axoniq.usage.url", "https://custom.url");
        Assertions.assertEquals((Object)"https://custom.url", (Object)this.provider.getUrl());
    }

    @Test
    void getUrlNullWhenUnset() {
        Assertions.assertNull((Object)this.provider.getUrl());
    }

    @Test
    void priority() {
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)this.provider.priority());
    }
}

