/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.configuration;

import java.util.HashMap;
import java.util.Map;
import org.axonframework.updates.configuration.EnvironmentVariableUsagePropertyProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class EnvironmentVariableUsagePropertyProviderTest {
    private final Map<String, String> env = new HashMap<String, String>();
    private EnvironmentVariableUsagePropertyProvider provider;

    EnvironmentVariableUsagePropertyProviderTest() {
    }

    @BeforeEach
    void setup() {
        this.env.clear();
        this.provider = new EnvironmentVariableUsagePropertyProvider(this.env::get);
    }

    @Test
    void getDisabledTrue() {
        this.env.put("AXONIQ_UPDATE_CHECKER_DISABLED", "true");
        Assertions.assertTrue((boolean)this.provider.getDisabled());
    }

    @Test
    void getDisabledFalse() {
        this.env.put("AXONIQ_UPDATE_CHECKER_DISABLED", "false");
        Assertions.assertFalse((boolean)this.provider.getDisabled());
    }

    @Test
    void getDisabledNullWhenUnset() {
        Assertions.assertNull((Object)this.provider.getDisabled());
    }

    @Test
    void getUrl() {
        this.env.put("AXONIQ_UPDATE_CHECKER_URL", "https://env.url");
        Assertions.assertEquals((Object)"https://env.url", (Object)this.provider.getUrl());
    }

    @Test
    void getUrlNullWhenUnset() {
        Assertions.assertNull((Object)this.provider.getUrl());
    }

    @Test
    void priority() {
        Assertions.assertEquals((int)0x3FFFFFFF, (int)this.provider.priority());
    }
}

