/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.configuration;

import java.util.Arrays;
import org.axonframework.updates.configuration.DummyProvider;
import org.axonframework.updates.configuration.HierarchicalUsagePropertyProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HierarchicalUsagePropertyProviderTest {
    HierarchicalUsagePropertyProviderTest() {
    }

    @Test
    void getDisabled_returnsFirstNonNullByPriority() {
        DummyProvider low = new DummyProvider(null, null, 1);
        DummyProvider mid = new DummyProvider(false, null, 5);
        DummyProvider high = new DummyProvider(true, null, 10);
        HierarchicalUsagePropertyProvider provider = new HierarchicalUsagePropertyProvider(Arrays.asList(low, mid, high));
        Assertions.assertTrue((boolean)provider.getDisabled());
    }

    @Test
    void getDisabled_skipsNullsAndReturnsNext() {
        DummyProvider low = new DummyProvider(null, null, 1);
        DummyProvider high = new DummyProvider(null, null, 10);
        DummyProvider mid = new DummyProvider(false, null, 5);
        HierarchicalUsagePropertyProvider provider = new HierarchicalUsagePropertyProvider(Arrays.asList(low, mid, high));
        Assertions.assertFalse((boolean)provider.getDisabled());
    }

    @Test
    void getDisabled_returnsFalseIfAllNull() {
        DummyProvider low = new DummyProvider(null, null, 1);
        DummyProvider high = new DummyProvider(null, null, 10);
        HierarchicalUsagePropertyProvider provider = new HierarchicalUsagePropertyProvider(Arrays.asList(low, high));
        Assertions.assertFalse((boolean)provider.getDisabled());
    }

    @Test
    void getUrl_returnsFirstNonNullByPriority() {
        DummyProvider low = new DummyProvider(null, null, 1);
        DummyProvider mid = new DummyProvider(null, "http://mid", 5);
        DummyProvider high = new DummyProvider(null, "http://high", 10);
        HierarchicalUsagePropertyProvider provider = new HierarchicalUsagePropertyProvider(Arrays.asList(low, mid, high));
        Assertions.assertEquals((Object)"http://high", (Object)provider.getUrl());
    }

    @Test
    void getUrl_skipsNullsAndReturnsNext() {
        DummyProvider low = new DummyProvider(null, null, 1);
        DummyProvider high = new DummyProvider(null, null, 10);
        DummyProvider mid = new DummyProvider(null, "http://mid", 5);
        HierarchicalUsagePropertyProvider provider = new HierarchicalUsagePropertyProvider(Arrays.asList(low, mid, high));
        Assertions.assertEquals((Object)"http://mid", (Object)provider.getUrl());
    }

    @Test
    void getUrl_returnsEmptyIfAllNull() {
        DummyProvider low = new DummyProvider(null, null, 1);
        DummyProvider high = new DummyProvider(null, null, 10);
        HierarchicalUsagePropertyProvider provider = new HierarchicalUsagePropertyProvider(Arrays.asList(low, high));
        Assertions.assertEquals((Object)"", (Object)provider.getUrl());
    }
}

