/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.axonframework.updates.configuration.DefaultUsagePropertyProvider;
import org.axonframework.updates.configuration.PropertyFileUsagePropertyProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PropertyFileUsagePropertyProviderTest {
    private final PropertyFileUsagePropertyProvider provider = new PropertyFileUsagePropertyProvider();
    private Path tempHome;
    private File propFile;

    PropertyFileUsagePropertyProviderTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.tempHome = Files.createTempDirectory("axon-test-home", new FileAttribute[0]);
        System.setProperty("user.home", this.tempHome.toString());
        this.propFile = new File(this.tempHome.toString() + "/.axoniq/update-checker.properties");
        if (this.propFile.exists()) {
            this.propFile.delete();
        }
    }

    @AfterEach
    void cleanup() throws Exception {
        File parent;
        System.clearProperty("user.home");
        if (this.propFile.exists()) {
            this.propFile.delete();
        }
        if ((parent = this.propFile.getParentFile()).exists()) {
            parent.delete();
        }
        Files.deleteIfExists(this.tempHome);
    }

    @Test
    void readsExistingPropertiesFile() throws Exception {
        Properties props = new Properties();
        props.setProperty("telemetry_url", "https://custom.url");
        props.setProperty("disabled", "true");
        this.propFile.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(this.propFile);){
            props.store(out, "Test");
        }
        Assertions.assertTrue((boolean)this.provider.getDisabled());
        Assertions.assertEquals((Object)"https://custom.url", (Object)this.provider.getUrl());
    }

    @Test
    void createsFileWithDefaultValuesIfNotExists() throws Exception {
        Assertions.assertFalse((boolean)this.propFile.exists());
        Assertions.assertEquals((Object)DefaultUsagePropertyProvider.INSTANCE.getDisabled(), (Object)this.provider.getDisabled());
        Assertions.assertEquals((Object)DefaultUsagePropertyProvider.INSTANCE.getUrl(), (Object)this.provider.getUrl());
        Assertions.assertTrue((boolean)this.propFile.exists());
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(this.propFile.toPath(), new OpenOption[0]);){
            props.load(in);
        }
        Assertions.assertEquals((Object)DefaultUsagePropertyProvider.INSTANCE.getUrl(), (Object)props.getProperty("telemetry_url"));
        Assertions.assertEquals((Object)String.valueOf(DefaultUsagePropertyProvider.INSTANCE.getDisabled()), (Object)props.getProperty("opted_out"));
    }
}

