/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.detection;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.axonframework.updates.detection.MachineId;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MachineIdTest {
    private Path tempHome;
    private File idFile;
    private String originalUserHome;

    MachineIdTest() {
    }

    @BeforeEach
    void setup() throws IOException {
        this.originalUserHome = System.getProperty("user.home");
        this.tempHome = Files.createTempDirectory("axon-machineid-test", new FileAttribute[0]);
        System.setProperty("user.home", this.tempHome.toString());
        this.idFile = new File(this.tempHome.toString() + "/.axoniq/.machine-id");
        if (this.idFile.exists()) {
            this.idFile.delete();
        }
    }

    @AfterEach
    void cleanup() throws IOException {
        File parent;
        if (this.originalUserHome != null) {
            System.setProperty("user.home", this.originalUserHome);
        } else {
            System.clearProperty("user.home");
        }
        if (this.idFile.exists()) {
            this.idFile.delete();
        }
        if ((parent = this.idFile.getParentFile()).exists()) {
            parent.delete();
        }
        Files.deleteIfExists(this.tempHome);
    }

    @Test
    void returnsExistingIdIfFileExists() throws Exception {
        String expectedId = UUID.randomUUID().toString();
        this.idFile.getParentFile().mkdirs();
        Files.write(this.idFile.toPath(), expectedId.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        MachineId machineId = new MachineId();
        Assertions.assertEquals((Object)expectedId, (Object)machineId.get());
    }

    @Test
    void createsIdFileIfNotExists() throws Exception {
        Assertions.assertFalse((boolean)this.idFile.exists());
        MachineId machineId = new MachineId();
        String id = machineId.get();
        Assertions.assertTrue((boolean)this.idFile.exists());
        String fileContent = new String(Files.readAllBytes(this.idFile.toPath()));
        Assertions.assertEquals((Object)id, (Object)fileContent);
        Assertions.assertDoesNotThrow(() -> UUID.fromString(id));
    }
}

