/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.detection;

import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.updates.detection.TestEnvironmentDetector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestEnvironmentDetectorTest {
    TestEnvironmentDetectorTest() {
    }

    @AfterEach
    void cleanup() {
        System.clearProperty("axoniq.usage.force-test-environment");
    }

    @Test
    void shouldDetectTestEnvironment() {
        Assertions.assertTrue((boolean)TestEnvironmentDetector.isTestEnvironment());
    }

    @Test
    void forceShouldDisableTestEnvironmentDetection() {
        System.setProperty("axoniq.usage.force-test-environment", "true");
        Assertions.assertFalse((boolean)TestEnvironmentDetector.isTestEnvironment());
    }

    @Test
    void shouldSeeNonTestEnvironment() {
        AtomicReference<Object> isTestEnvironment = new AtomicReference<Object>(null);
        Thread nonTestThread = new Thread(() -> isTestEnvironment.set(TestEnvironmentDetector.isTestEnvironment()));
        nonTestThread.start();
        try {
            nonTestThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Assertions.fail((String)"Thread was interrupted", (Throwable)e);
        }
        Assertions.assertFalse((boolean)((Boolean)isTestEnvironment.get()).booleanValue(), (String)"The thread should not be detected as a test environment,");
    }
}

