/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.utils;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.messaging.MetaData;

public abstract class EventTestUtils {
    public static final String PAYLOAD = "payload";
    public static final String AGGREGATE = "aggregate";
    private static final String TYPE = "type";
    private static final MetaData METADATA = MetaData.emptyInstance();

    public static List<DomainEventMessage<?>> createEvents(int numberOfEvents) {
        return IntStream.range(0, numberOfEvents).mapToObj(sequenceNumber -> EventTestUtils.createEvent(TYPE, IdentifierFactory.getInstance().generateIdentifier(), AGGREGATE, sequenceNumber, PAYLOAD + sequenceNumber, METADATA)).collect(Collectors.toList());
    }

    public static List<DomainEventMessage<?>> createUUIDEvents(int numberOfEvents) {
        return IntStream.range(0, numberOfEvents).mapToObj(sequenceNumber -> EventTestUtils.createEvent(TYPE, IdentifierFactory.getInstance().generateIdentifier(), UUID.randomUUID().toString(), sequenceNumber, PAYLOAD + sequenceNumber, METADATA)).collect(Collectors.toList());
    }

    public static DomainEventMessage<String> createEvent() {
        return EventTestUtils.createEvent(0L);
    }

    public static DomainEventMessage<String> createEvent(long sequenceNumber) {
        return EventTestUtils.createEvent(AGGREGATE, sequenceNumber);
    }

    public static DomainEventMessage<String> createEvent(long sequenceNumber, Instant timestamp) {
        return new GenericDomainEventMessage(TYPE, AGGREGATE, sequenceNumber, (Object)PAYLOAD, (Map)METADATA, IdentifierFactory.getInstance().generateIdentifier(), timestamp);
    }

    public static DomainEventMessage<String> createEvent(String aggregateId, long sequenceNumber) {
        return EventTestUtils.createEvent(aggregateId, sequenceNumber, PAYLOAD);
    }

    public static DomainEventMessage<String> createEvent(String aggregateId, long sequenceNumber, String payload) {
        return EventTestUtils.createEvent(TYPE, IdentifierFactory.getInstance().generateIdentifier(), aggregateId, sequenceNumber, payload, METADATA);
    }

    public static DomainEventMessage<String> createEvent(String eventId, String aggregateId, long sequenceNumber) {
        return EventTestUtils.createEvent(TYPE, eventId, aggregateId, sequenceNumber, PAYLOAD, METADATA);
    }

    public static DomainEventMessage<String> createEvent(String type, String eventId, String aggregateId, long sequenceNumber, String payload, MetaData metaData) {
        return new GenericDomainEventMessage(type, aggregateId, sequenceNumber, (Object)payload, (Map)metaData, eventId, GenericDomainEventMessage.clock.instant());
    }

    private EventTestUtils() {
    }
}

