/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.jobrunr;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.jobrunr.LabelUtils;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.SchedulingException;
import org.axonframework.eventhandling.scheduling.jobrunr.JobRunrScheduleToken;
import org.axonframework.lifecycle.Lifecycle;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.jobrunr.jobs.JobId;
import org.jobrunr.jobs.lambdas.JobLambda;
import org.jobrunr.scheduling.JobBuilder;
import org.jobrunr.scheduling.JobScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunrEventScheduler
implements EventScheduler,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(JobRunrEventScheduler.class);
    private final JobScheduler jobScheduler;
    private final String jobName;
    private final Serializer serializer;
    private final TransactionManager transactionManager;
    private final EventBus eventBus;

    protected JobRunrEventScheduler(Builder builder) {
        builder.validate();
        this.jobScheduler = builder.jobScheduler;
        this.jobName = builder.jobName;
        this.serializer = builder.serializer;
        this.transactionManager = builder.transactionManager;
        this.eventBus = builder.eventBus;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ScheduleToken schedule(Instant triggerDateTime, Object event) {
        UUID jobIdentifier = UUID.randomUUID();
        try {
            JobBuilder job = JobBuilder.aJob().withId(jobIdentifier).withName(this.jobName).withLabels(new String[]{LabelUtils.getLabel(this.jobName)}).scheduleAt((Temporal)triggerDateTime);
            if (event instanceof EventMessage) {
                this.addDetailsFromEvent(job, (EventMessage)event);
            } else {
                this.addDetailsFromObject(job, event);
            }
            JobId id = this.jobScheduler.create(job);
            logger.debug("Job with id: [{}] was successfully created.", (Object)id);
        }
        catch (Exception e) {
            throw new SchedulingException("An error occurred while scheduling an event.", e);
        }
        return new JobRunrScheduleToken(jobIdentifier);
    }

    private void addDetailsFromObject(JobBuilder job, Object event) {
        SerializedObject<String> serialized = this.serializer.serialize(event, String.class);
        String serializedPayload = serialized.getData();
        String payloadClass = serialized.getType().getName();
        String revision = serialized.getType().getRevision();
        if (Objects.isNull(revision)) {
            job.withDetails((JobLambda & Serializable)() -> this.publish(serializedPayload, payloadClass));
        } else {
            job.withDetails((JobLambda & Serializable)() -> this.publishWithRevision(serializedPayload, payloadClass, revision));
        }
    }

    private void addDetailsFromEvent(JobBuilder job, EventMessage eventMessage) {
        SerializedObject<String> serialized = this.serializer.serialize(eventMessage.getPayload(), String.class);
        String serializedPayload = serialized.getData();
        String payloadClass = serialized.getType().getName();
        String revision = serialized.getType().getRevision();
        String serializedMetadata = this.serializer.serialize(eventMessage.getMetaData(), String.class).getData();
        if (Objects.isNull(revision)) {
            job.withDetails((JobLambda & Serializable)() -> this.publish(serializedPayload, payloadClass, serializedMetadata));
        } else {
            job.withDetails((JobLambda & Serializable)() -> this.publishWithRevision(serializedPayload, payloadClass, revision, serializedMetadata));
        }
    }

    @Override
    public ScheduleToken schedule(Duration triggerDuration, Object event) {
        return this.schedule(GenericEventMessage.clock.instant().plus(triggerDuration), event);
    }

    @Override
    public void cancelSchedule(ScheduleToken scheduleToken) {
        if (!(scheduleToken instanceof JobRunrScheduleToken)) {
            throw new IllegalArgumentException("The given ScheduleToken was not provided by this scheduler.");
        }
        JobRunrScheduleToken reference = (JobRunrScheduleToken)scheduleToken;
        this.jobScheduler.delete(reference.getJobIdentifier(), "Deleted via Axon EventScheduler API");
    }

    @Override
    public void shutdown() {
        this.jobScheduler.shutdown();
    }

    @Override
    public void registerLifecycleHandlers(@Nonnull Lifecycle.LifecycleRegistry lifecycle) {
        lifecycle.onShutdown(0x3FFFFFFF, this::shutdown);
    }

    public void publish(String serializedPayload, String payloadClass) {
        logger.debug("Invoked by JobRunr to publish a scheduled event without metadata.");
        EventMessage<?> eventMessage = this.createMessage(serializedPayload, payloadClass, null);
        this.publishEventMessage(eventMessage);
    }

    public void publish(String serializedPayload, String payloadClass, String serializedMetadata) {
        logger.debug("Invoked by JobRunr to publish a scheduled event with metadata");
        EventMessage<?> eventMessage = this.createMessage(serializedPayload, payloadClass, null, serializedMetadata);
        this.publishEventMessage(eventMessage);
    }

    public void publishWithRevision(String serializedPayload, String payloadClass, String revision) {
        logger.debug("Invoked by JobRunr to publish a scheduled event without metadata.");
        EventMessage<?> eventMessage = this.createMessage(serializedPayload, payloadClass, revision);
        this.publishEventMessage(eventMessage);
    }

    public void publishWithRevision(String serializedPayload, String payloadClass, String revision, String serializedMetadata) {
        logger.debug("Invoked by JobRunr to publish a scheduled event with metadata");
        EventMessage<?> eventMessage = this.createMessage(serializedPayload, payloadClass, revision, serializedMetadata);
        this.publishEventMessage(eventMessage);
    }

    private EventMessage<?> createMessage(String serializedPayload, String payloadClass, String revision) {
        SimpleSerializedObject<String> serializedObject = new SimpleSerializedObject<String>(serializedPayload, String.class, payloadClass, revision);
        Object deserializedPayload = this.serializer.deserialize(serializedObject);
        return GenericEventMessage.asEventMessage(deserializedPayload);
    }

    private EventMessage<?> createMessage(String serializedPayload, String payloadClass, String revision, String serializedMetadata) {
        EventMessage<?> eventMessage = this.createMessage(serializedPayload, payloadClass, revision);
        SimpleSerializedObject<String> serializedMetaData = new SimpleSerializedObject<String>(serializedMetadata, String.class, MetaData.class.getName(), null);
        return eventMessage.andMetaData((Map)this.serializer.deserialize(serializedMetaData));
    }

    private void publishEventMessage(EventMessage eventMessage) {
        DefaultUnitOfWork<Object> unitOfWork = DefaultUnitOfWork.startAndGet(null);
        unitOfWork.attachTransaction(this.transactionManager);
        unitOfWork.execute(() -> this.eventBus.publish(eventMessage));
    }

    public static class Builder {
        private JobScheduler jobScheduler;
        private String jobName = "AxonScheduledEvent";
        private Serializer serializer;
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private EventBus eventBus;

        public Builder jobScheduler(JobScheduler jobScheduler) {
            BuilderUtils.assertNonNull(jobScheduler, "JobScheduler may not be null");
            this.jobScheduler = jobScheduler;
            return this;
        }

        public Builder jobName(String jobName) {
            BuilderUtils.assertNonNull(jobName, "JobName may not be null");
            this.jobName = jobName;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            BuilderUtils.assertNonNull(eventBus, "EventBus may not be null");
            this.eventBus = eventBus;
            return this;
        }

        public JobRunrEventScheduler build() {
            return new JobRunrEventScheduler(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.jobScheduler, "The JobScheduler is a hard requirement and should be provided.");
            BuilderUtils.assertNonNull(this.serializer, "The Serializer is a hard requirement and should be provided.");
            BuilderUtils.assertNonNull(this.eventBus, "The EventBus is a hard requirement and should be provided.");
        }
    }
}

