/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.api;

import java.util.Objects;

public class Artifact {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public Artifact(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String groupId() {
        return this.groupId;
    }

    public String shortGroupId() {
        if (this.groupId.startsWith("org.axonframework.extensions")) {
            if (this.groupId.length() == 28) {
                return "ext";
            }
            return "ext." + this.groupId.substring(29);
        }
        if (this.groupId.startsWith("org.axonframework")) {
            if (this.groupId.length() == 17) {
                return "fw";
            }
            return "fw." + this.groupId.substring(18);
        }
        if (this.groupId.startsWith("io.axoniq")) {
            if (this.groupId.length() == 9) {
                return "iq";
            }
            return "iq." + this.groupId.substring(10);
        }
        return this.groupId;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return Objects.equals(this.groupId, artifact.groupId) && Objects.equals(this.artifactId, artifact.artifactId) && Objects.equals(this.version, artifact.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    public String toString() {
        return "Artifact{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

