/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.distributed.CommandBusConnectorCommunicationException;
import org.axonframework.commandhandling.distributed.CommandCallbackWrapper;

public class CommandCallbackRepository<A> {
    private final Map<String, CommandCallbackWrapper> callbacks = new ConcurrentHashMap<String, CommandCallbackWrapper>();

    public void cancelCallbacks(A channelId) {
        Iterator<CommandCallbackWrapper> callbacks = this.callbacks.values().iterator();
        while (callbacks.hasNext()) {
            CommandCallbackWrapper wrapper = callbacks.next();
            if (!wrapper.getChannelIdentifier().equals(channelId)) continue;
            wrapper.reportResult(GenericCommandResultMessage.asCommandResultMessage(new CommandBusConnectorCommunicationException(String.format("Connection error while waiting for a response on command %s", wrapper.getMessage().getCommandName()))));
            callbacks.remove();
        }
    }

    public <E, C, R> CommandCallbackWrapper<E, C, R> fetchAndRemove(String callbackId) {
        return this.callbacks.remove(callbackId);
    }

    public <E, C, R> void store(String callbackId, CommandCallbackWrapper<E, C, R> commandCallbackWrapper) {
        CommandCallbackWrapper previous = this.callbacks.put(callbackId, commandCallbackWrapper);
        if (previous != null) {
            previous.reportResult(GenericCommandResultMessage.asCommandResultMessage(new CommandBusConnectorCommunicationException("Command-callback cancelled, a new command with the same ID is entered into the command bus")));
        }
    }

    protected Map<String, CommandCallbackWrapper> callbacks() {
        return this.callbacks;
    }
}

