/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.quartz;

import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonNonTransientException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ExceptionUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.AbstractDeadlineManager;
import org.axonframework.deadline.DeadlineException;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.deadline.quartz.DeadlineJob;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzDeadlineManager
extends AbstractDeadlineManager {
    private static final Logger logger = LoggerFactory.getLogger(QuartzDeadlineManager.class);
    private static final String JOB_NAME_PREFIX = "deadline-";
    private final Scheduler scheduler;
    private final ScopeAwareProvider scopeAwareProvider;
    private final TransactionManager transactionManager;
    private final Serializer serializer;
    private final Predicate<Throwable> refireImmediatelyPolicy;

    public static Builder builder() {
        return new Builder();
    }

    protected QuartzDeadlineManager(Builder builder) {
        builder.validate();
        this.scheduler = builder.scheduler;
        this.scopeAwareProvider = builder.scopeAwareProvider;
        this.transactionManager = builder.transactionManager;
        this.serializer = (Serializer)builder.serializer.get();
        this.refireImmediatelyPolicy = builder.refireImmediatelyPolicy;
        try {
            this.initialize();
        }
        catch (SchedulerException e) {
            throw new AxonConfigurationException("Unable to initialize QuartzDeadlineManager", e);
        }
    }

    private void initialize() throws SchedulerException {
        this.scheduler.getContext().put(DeadlineJob.TRANSACTION_MANAGER_KEY, (Object)this.transactionManager);
        this.scheduler.getContext().put(DeadlineJob.SCOPE_AWARE_RESOLVER, (Object)this.scopeAwareProvider);
        this.scheduler.getContext().put(DeadlineJob.JOB_DATA_SERIALIZER, (Object)this.serializer);
        this.scheduler.getContext().put(DeadlineJob.HANDLER_INTERCEPTORS, this.handlerInterceptors());
        this.scheduler.getContext().put("refireImmediatelyPolicy", this.refireImmediatelyPolicy);
    }

    @Override
    public String schedule(Instant triggerDateTime, String deadlineName, Object messageOrPayload, ScopeDescriptor deadlineScope) {
        DeadlineMessage deadlineMessage = GenericDeadlineMessage.asDeadlineMessage(deadlineName, messageOrPayload);
        String deadlineId = JOB_NAME_PREFIX + deadlineMessage.getIdentifier();
        this.runOnPrepareCommitOrNow(() -> {
            DeadlineMessage interceptedDeadlineMessage = this.processDispatchInterceptors(deadlineMessage);
            try {
                JobDetail jobDetail = this.buildJobDetail(interceptedDeadlineMessage, deadlineScope, new JobKey(deadlineId, deadlineName));
                this.scheduler.scheduleJob(jobDetail, QuartzDeadlineManager.buildTrigger(triggerDateTime, jobDetail.getKey()));
            }
            catch (SchedulerException e) {
                throw new DeadlineException("An error occurred while setting a timer for a deadline", e);
            }
        });
        return deadlineId;
    }

    @Override
    public String schedule(Duration triggerDuration, String deadlineName, Object messageOrPayload, ScopeDescriptor deadlineScope) {
        return this.schedule(Instant.now().plus(triggerDuration), deadlineName, messageOrPayload, deadlineScope);
    }

    @Override
    public void cancelSchedule(String deadlineName, String scheduleId) {
        this.runOnPrepareCommitOrNow(() -> this.cancelSchedule(JobKey.jobKey((String)scheduleId, (String)deadlineName)));
    }

    @Override
    public void cancelAll(String deadlineName) {
        this.runOnPrepareCommitOrNow(() -> {
            try {
                this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)deadlineName)).forEach(this::cancelSchedule);
            }
            catch (SchedulerException e) {
                throw new DeadlineException("An error occurred while cancelling a timer for a deadline manager", e);
            }
        });
    }

    private void cancelSchedule(JobKey jobKey) {
        try {
            if (!this.scheduler.deleteJob(jobKey)) {
                logger.warn("The job belonging to this token could not be deleted.");
            }
        }
        catch (SchedulerException e) {
            throw new DeadlineException("An error occurred while cancelling a timer for a deadline manager", e);
        }
    }

    private JobDetail buildJobDetail(DeadlineMessage deadlineMessage, ScopeDescriptor deadlineScope, JobKey jobKey) {
        JobDataMap jobData = DeadlineJob.DeadlineJobDataBinder.toJobData(this.serializer, deadlineMessage, deadlineScope);
        return JobBuilder.newJob(DeadlineJob.class).withDescription(deadlineMessage.getPayloadType().getName()).withIdentity(jobKey).usingJobData(jobData).build();
    }

    private static Trigger buildTrigger(Instant triggerDateTime, JobKey key) {
        return TriggerBuilder.newTrigger().forJob(key).startAt(Date.from(triggerDateTime)).build();
    }

    public static class Builder {
        private Scheduler scheduler;
        private ScopeAwareProvider scopeAwareProvider;
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private Supplier<Serializer> serializer = XStreamSerializer::defaultSerializer;
        private Predicate<Throwable> refireImmediatelyPolicy = throwable -> !ExceptionUtils.findException(throwable, t -> t instanceof AxonNonTransientException).isPresent();

        public Builder scheduler(Scheduler scheduler) {
            BuilderUtils.assertNonNull(scheduler, "Scheduler may not be null");
            this.scheduler = scheduler;
            return this;
        }

        public Builder scopeAwareProvider(ScopeAwareProvider scopeAwareProvider) {
            BuilderUtils.assertNonNull(scopeAwareProvider, "ScopeAwareProvider may not be null");
            this.scopeAwareProvider = scopeAwareProvider;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = () -> serializer;
            return this;
        }

        public Builder refireImmediatelyPolicy(Predicate<Throwable> refireImmediatelyPolicy) {
            BuilderUtils.assertNonNull(refireImmediatelyPolicy, "The refire policy may not be null");
            this.refireImmediatelyPolicy = refireImmediatelyPolicy;
            return this;
        }

        public QuartzDeadlineManager build() {
            return new QuartzDeadlineManager(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.scheduler, "The Scheduler is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.scopeAwareProvider, "The ScopeAwareProvider is a hard requirement and should be provided");
        }
    }
}

