/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.WrappedToken;
import org.axonframework.messaging.Message;

public class ReplayToken
implements TrackingToken,
WrappedToken,
Serializable {
    private static final long serialVersionUID = -4102464856247630944L;
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    private final TrackingToken tokenAtReset;
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    private final TrackingToken currentToken;
    private final transient boolean lastMessageWasReplay;

    public static TrackingToken createReplayToken(TrackingToken tokenAtReset, TrackingToken startPosition) {
        if (tokenAtReset == null) {
            return null;
        }
        if (tokenAtReset instanceof ReplayToken) {
            return ReplayToken.createReplayToken(((ReplayToken)tokenAtReset).tokenAtReset, startPosition);
        }
        if (startPosition != null && startPosition.covers(WrappedToken.unwrapLowerBound(tokenAtReset))) {
            return startPosition;
        }
        return new ReplayToken(tokenAtReset, startPosition);
    }

    public static TrackingToken createReplayToken(TrackingToken tokenAtReset) {
        return ReplayToken.createReplayToken(tokenAtReset, null);
    }

    public static boolean isReplay(Message<?> message) {
        return message instanceof TrackedEventMessage && ReplayToken.isReplay(((TrackedEventMessage)message).trackingToken());
    }

    public static boolean isReplay(TrackingToken trackingToken) {
        return WrappedToken.unwrap(trackingToken, ReplayToken.class).map(rt -> rt.isReplay()).orElse(false);
    }

    public ReplayToken(TrackingToken tokenAtReset) {
        this(tokenAtReset, null);
    }

    @JsonCreator
    @ConstructorProperties(value={"tokenAtReset", "currentToken"})
    public ReplayToken(@JsonProperty(value="tokenAtReset") TrackingToken tokenAtReset, @JsonProperty(value="currentToken") TrackingToken newRedeliveryToken) {
        this(tokenAtReset, newRedeliveryToken, true);
    }

    private ReplayToken(TrackingToken tokenAtReset, TrackingToken newRedeliveryToken, boolean lastMessageWasReplay) {
        this.tokenAtReset = tokenAtReset;
        this.currentToken = newRedeliveryToken;
        this.lastMessageWasReplay = lastMessageWasReplay;
    }

    public TrackingToken getTokenAtReset() {
        return this.tokenAtReset;
    }

    public TrackingToken getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public TrackingToken advancedTo(TrackingToken newToken) {
        if (this.tokenAtReset == null || newToken.covers(WrappedToken.unwrapUpperBound(this.tokenAtReset)) && !this.tokenAtReset.covers(WrappedToken.unwrapLowerBound(newToken))) {
            if (this.tokenAtReset instanceof WrappedToken) {
                return ((WrappedToken)this.tokenAtReset).advancedTo(newToken);
            }
            return newToken;
        }
        if (this.tokenAtReset.covers(WrappedToken.unwrapLowerBound(newToken))) {
            return new ReplayToken(this.tokenAtReset, newToken, true);
        }
        if (this.tokenAtReset instanceof WrappedToken) {
            return new ReplayToken(this.tokenAtReset.upperBound(newToken), ((WrappedToken)this.tokenAtReset).advancedTo(newToken), false);
        }
        return new ReplayToken(this.tokenAtReset.upperBound(newToken), newToken, false);
    }

    @Override
    public TrackingToken lowerBound(TrackingToken other) {
        if (other instanceof ReplayToken) {
            return new ReplayToken(this, ((ReplayToken)other).currentToken);
        }
        return new ReplayToken(this, other);
    }

    @Override
    public TrackingToken upperBound(TrackingToken other) {
        return this.advancedTo(other);
    }

    @Override
    public boolean covers(TrackingToken other) {
        if (other instanceof ReplayToken) {
            return this.currentToken != null && this.currentToken.covers(((ReplayToken)other).currentToken);
        }
        return this.currentToken != null && this.currentToken.covers(other);
    }

    private boolean isReplay() {
        return this.lastMessageWasReplay;
    }

    @Override
    public TrackingToken lowerBound() {
        return WrappedToken.unwrapLowerBound(this.currentToken);
    }

    @Override
    public TrackingToken upperBound() {
        return WrappedToken.unwrapUpperBound(this.currentToken);
    }

    @Override
    public <R extends TrackingToken> Optional<R> unwrap(Class<R> tokenType) {
        if (tokenType.isInstance(this)) {
            return Optional.of(tokenType.cast(this));
        }
        return WrappedToken.unwrap(this.currentToken, tokenType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayToken that = (ReplayToken)o;
        return Objects.equals(this.tokenAtReset, that.tokenAtReset) && Objects.equals(this.currentToken, that.currentToken);
    }

    public int hashCode() {
        return Objects.hash(this.tokenAtReset, this.currentToken);
    }

    public String toString() {
        return "ReplayToken{currentToken=" + this.currentToken + ", tokenAtReset=" + this.tokenAtReset + '}';
    }

    @Override
    public OptionalLong position() {
        if (this.currentToken != null) {
            return this.currentToken.position();
        }
        return OptionalLong.empty();
    }
}

