/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.jdbc;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.JdbcException;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.AbstractTokenEntry;
import org.axonframework.eventhandling.tokenstore.ConfigToken;
import org.axonframework.eventhandling.tokenstore.GenericTokenEntry;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToInitializeTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToRetrieveIdentifierException;
import org.axonframework.eventhandling.tokenstore.jdbc.TokenSchema;
import org.axonframework.eventhandling.tokenstore.jdbc.TokenTableFactory;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTokenStore
implements TokenStore {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTokenStore.class);
    private static final String CONFIG_TOKEN_ID = "__config";
    private static final int CONFIG_SEGMENT = 0;
    private final ConnectionProvider connectionProvider;
    private final Serializer serializer;
    private final TokenSchema schema;
    private final TemporalAmount claimTimeout;
    private final String nodeId;
    private final Class<?> contentType;

    public static Builder builder() {
        return new Builder();
    }

    protected JdbcTokenStore(Builder builder) {
        builder.validate();
        this.connectionProvider = builder.connectionProvider;
        this.serializer = builder.serializer;
        this.schema = builder.schema;
        this.claimTimeout = builder.claimTimeout;
        this.nodeId = builder.nodeId;
        this.contentType = builder.contentType;
    }

    public void createSchema(TokenTableFactory schemaFactory) {
        Connection c = this.getConnection();
        try {
            JdbcUtils.executeUpdates(c, e -> {
                throw new JdbcException("Failed to create token tables", (Throwable)e);
            }, connection -> schemaFactory.createTable(connection, this.schema));
        }
        finally {
            JdbcUtils.closeQuietly(c);
        }
    }

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount) throws UnableToClaimTokenException {
        this.initializeTokenSegments(processorName, segmentCount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeTokenSegments(String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        Connection connection = this.getConnection();
        try {
            JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, 0), resultSet -> {
                for (int segment = 0; segment < segmentCount; ++segment) {
                    this.insertTokenEntry(connection, initialToken, processorName, segment);
                }
                return null;
            }, e -> new UnableToClaimTokenException("Could not initialize segments. Some segments were already present.", (Throwable)e));
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSegment(TrackingToken token, String processorName, int segment) throws UnableToInitializeTokenException {
        Connection connection = this.getConnection();
        try {
            JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, 0), resultSet -> {
                this.insertTokenEntry(connection, token, processorName, segment);
                return null;
            }, e -> new UnableToInitializeTokenException("Could not initialize segments. Some segments were already present.", (Throwable)e));
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    @Override
    public boolean requiresExplicitSegmentInitialization() {
        return true;
    }

    @Override
    public Optional<String> retrieveStorageIdentifier() throws UnableToRetrieveIdentifierException {
        return Optional.of(this.loadConfigurationToken()).map(configToken -> configToken.get("id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigToken loadConfigurationToken() throws UnableToRetrieveIdentifierException {
        TrackingToken token;
        Connection connection = this.getConnection();
        try {
            token = JdbcUtils.executeQuery(connection, c -> this.select(connection, CONFIG_TOKEN_ID, 0, false), resultSet -> {
                if (resultSet.next()) {
                    return this.readTokenEntry(resultSet).getToken(this.serializer);
                }
                return null;
            }, e -> new UnableToRetrieveIdentifierException("Exception while attempting to retrieve the config token", (Throwable)e));
            try {
                if (token == null) {
                    token = this.insertTokenEntry(connection, new ConfigToken(Collections.singletonMap("id", UUID.randomUUID().toString())), CONFIG_TOKEN_ID, 0);
                }
            }
            catch (SQLException e2) {
                throw new UnableToRetrieveIdentifierException("Exception while attempting to initialize the config token. It may have been concurrently initialized.", e2);
            }
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
        return (ConfigToken)token;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeToken(TrackingToken token, String processorName, int segment) throws UnableToClaimTokenException {
        Connection connection = this.getConnection();
        try {
            int updatedToken = JdbcUtils.executeUpdate(connection, c -> this.storeUpdate(connection, token, processorName, segment), e -> new JdbcException(String.format("Could not store token [%s] for processor [%s] and segment [%d]", token, processorName, segment), (Throwable)e));
            if (updatedToken == 0) {
                logger.debug("Could not update token [{}] for processor [{}] and segment [{}]. Trying load-then-save approach instead.", new Object[]{token, processorName, segment});
                JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, segment), resultSet -> {
                    this.updateToken(connection, resultSet, token, processorName, segment);
                    return null;
                }, e -> new JdbcException(String.format("Could not store token [%s] for processor [%s] and segment [%d]", token, processorName, segment), (Throwable)e));
            }
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackingToken fetchToken(String processorName, int segment) throws UnableToClaimTokenException {
        Connection connection = this.getConnection();
        try {
            TrackingToken trackingToken = JdbcUtils.executeQuery(connection, c -> this.selectForUpdate(c, processorName, segment), resultSet -> this.loadToken(connection, resultSet, processorName, segment), e -> new JdbcException(String.format("Could not load token for processor [%s] and segment [%d]", processorName, segment), (Throwable)e));
            return trackingToken;
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseClaim(String processorName, int segment) {
        Connection connection = this.getConnection();
        try {
            int[] result = JdbcUtils.executeUpdates(connection, e -> {
                throw new JdbcException(String.format("Could not load token for processor [%s] and segment [%d]", processorName, segment), (Throwable)e);
            }, c -> this.releaseClaim(c, processorName, segment));
            if (result[0] < 1) {
                logger.warn("Releasing claim of token {}/{} failed. It was owned by another node.", (Object)processorName, (Object)segment);
            }
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteToken(String processorName, int segment) {
        Connection connection = this.getConnection();
        try {
            int[] result = JdbcUtils.executeUpdates(connection, e -> {
                throw new JdbcException(String.format("Could not remove token for processor [%s] and segment [%d]", processorName, segment), (Throwable)e);
            }, c -> this.deleteToken(c, processorName, segment));
            if (result[0] < 1) {
                throw new UnableToClaimTokenException("Unable to claim token. It wasn't owned by " + this.nodeId);
            }
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] fetchSegments(String processorName) {
        Connection connection = this.getConnection();
        try {
            List<Integer> integers = JdbcUtils.executeQuery(connection, c -> this.selectForSegments(c, processorName), JdbcUtils.listResults(rs -> rs.getInt(this.schema.segmentColumn())), e -> new JdbcException(String.format("Could not load segments for processor [%s]", processorName), (Throwable)e));
            int[] nArray = integers.stream().mapToInt(i -> i).toArray();
            return nArray;
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    protected PreparedStatement selectForSegments(Connection connection, String processorName) throws SQLException {
        String sql = "SELECT " + this.schema.segmentColumn() + " FROM " + this.schema.tokenTable() + " WHERE " + this.schema.processorNameColumn() + " = ? ORDER BY " + this.schema.segmentColumn() + " ASC";
        PreparedStatement preparedStatement = connection.prepareStatement(sql, 1003, 1007);
        preparedStatement.setString(1, processorName);
        return preparedStatement;
    }

    protected PreparedStatement storeUpdate(Connection connection, TrackingToken token, String processorName, int segment) throws SQLException {
        GenericTokenEntry tokenToStore = new GenericTokenEntry(token, this.serializer, this.contentType, processorName, segment);
        Object tokenDataToStore = ObjectUtils.getOrDefault(tokenToStore.getSerializedToken(), SerializedObject::getData, null);
        String tokenTypeToStore = ObjectUtils.getOrDefault(tokenToStore.getTokenType(), SerializedType::getName, null);
        String sql = "UPDATE " + this.schema.tokenTable() + " SET " + this.schema.tokenColumn() + " = ?, " + this.schema.tokenTypeColumn() + " = ?, " + this.schema.timestampColumn() + " = ? WHERE " + this.schema.ownerColumn() + " = ? AND " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ? ";
        PreparedStatement preparedStatement = connection.prepareStatement(sql, 1003, 1007);
        preparedStatement.setObject(1, tokenDataToStore);
        preparedStatement.setString(2, tokenTypeToStore);
        preparedStatement.setString(3, tokenToStore.timestampAsString());
        preparedStatement.setString(4, this.nodeId);
        preparedStatement.setString(5, processorName);
        preparedStatement.setInt(6, segment);
        return preparedStatement;
    }

    protected PreparedStatement selectForUpdate(Connection connection, String processorName, int segment) throws SQLException {
        return this.select(connection, processorName, segment, true);
    }

    protected PreparedStatement select(Connection connection, String processorName, int segment, boolean forUpdate) throws SQLException {
        String sql = "SELECT " + String.join((CharSequence)", ", this.schema.processorNameColumn(), this.schema.segmentColumn(), this.schema.tokenColumn(), this.schema.tokenTypeColumn(), this.schema.timestampColumn(), this.schema.ownerColum()) + " FROM " + this.schema.tokenTable() + " WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ? " + (forUpdate ? "FOR UPDATE" : "");
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, processorName);
        preparedStatement.setInt(2, segment);
        return preparedStatement;
    }

    protected void updateToken(Connection connection, ResultSet resultSet, TrackingToken token, String processorName, int segment) throws SQLException {
        block15: {
            String sql = "UPDATE " + this.schema.tokenTable() + " SET " + this.schema.ownerColum() + " = ?, " + this.schema.tokenColumn() + " = ?, " + this.schema.tokenTypeColumn() + " = ?, " + this.schema.timestampColumn() + " = ? WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ?";
            if (resultSet.next()) {
                AbstractTokenEntry<?> entry = this.readTokenEntry(resultSet);
                entry.updateToken(token, this.serializer);
                if (!entry.claim(this.nodeId, this.claimTimeout)) {
                    throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It is owned by '%s'", entry.getProcessorName(), entry.getSegment(), entry.getOwner()));
                }
                try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                    preparedStatement.setString(1, entry.getOwner());
                    preparedStatement.setObject(2, entry.getSerializedToken().getData());
                    preparedStatement.setString(3, entry.getSerializedToken().getType().getName());
                    preparedStatement.setString(4, entry.timestampAsString());
                    preparedStatement.setString(5, processorName);
                    preparedStatement.setInt(6, segment);
                    if (preparedStatement.executeUpdate() != 1) {
                        throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It has been removed", processorName, segment));
                    }
                    break block15;
                }
            }
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It has not been initialized yet", processorName, segment));
        }
    }

    protected TrackingToken claimToken(Connection connection, AbstractTokenEntry<?> entry) throws SQLException {
        String sql = "UPDATE " + this.schema.tokenTable() + " SET " + this.schema.ownerColum() + " = ?, " + this.schema.timestampColumn() + " = ? WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ?";
        if (!entry.claim(this.nodeId, this.claimTimeout)) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It is owned by '%s'", entry.getProcessorName(), entry.getSegment(), entry.getOwner()));
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, entry.getOwner());
            preparedStatement.setString(2, entry.timestampAsString());
            preparedStatement.setString(3, entry.getProcessorName());
            preparedStatement.setInt(4, entry.getSegment());
            if (preparedStatement.executeUpdate() != 1) {
                throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It has been removed", entry.getProcessorName(), entry.getSegment()));
            }
        }
        return entry.getToken(this.serializer);
    }

    protected TrackingToken loadToken(Connection connection, ResultSet resultSet, String processorName, int segment) throws SQLException {
        if (!resultSet.next()) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It has not been initialized yet", processorName, segment));
        }
        return this.claimToken(connection, this.readTokenEntry(resultSet));
    }

    protected TrackingToken insertTokenEntry(Connection connection, TrackingToken token, String processorName, int segment) throws SQLException {
        String sql = "INSERT INTO " + this.schema.tokenTable() + " (" + this.schema.processorNameColumn() + "," + this.schema.segmentColumn() + "," + this.schema.timestampColumn() + "," + this.schema.tokenColumn() + "," + this.schema.tokenTypeColumn() + "," + this.schema.ownerColum() + ") VALUES (?,?,?,?,?,?)";
        GenericTokenEntry entry = new GenericTokenEntry(token, this.serializer, this.contentType, processorName, segment);
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, processorName);
            preparedStatement.setInt(2, segment);
            preparedStatement.setString(3, entry.timestampAsString());
            preparedStatement.setObject(4, token == null ? null : entry.getSerializedToken().getData());
            preparedStatement.setString(5, token == null ? null : entry.getSerializedToken().getType().getName());
            preparedStatement.setString(6, entry.getOwner());
            preparedStatement.executeUpdate();
        }
        return token;
    }

    protected AbstractTokenEntry<?> readTokenEntry(ResultSet resultSet) throws SQLException {
        return new GenericTokenEntry(this.readSerializedData(resultSet, this.schema.tokenColumn()), resultSet.getString(this.schema.tokenTypeColumn()), resultSet.getString(this.schema.timestampColumn()), resultSet.getString(this.schema.ownerColum()), resultSet.getString(this.schema.processorNameColumn()), resultSet.getInt(this.schema.segmentColumn()), this.contentType);
    }

    protected PreparedStatement releaseClaim(Connection connection, String processorName, int segment) throws SQLException {
        String sql = "UPDATE " + this.schema.tokenTable() + " SET " + this.schema.ownerColum() + " = ?, " + this.schema.timestampColumn() + " = ? WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ? AND " + this.schema.ownerColum() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, DateTimeUtils.formatInstant(AbstractTokenEntry.clock.instant()));
        preparedStatement.setString(3, processorName);
        preparedStatement.setInt(4, segment);
        preparedStatement.setString(5, this.nodeId);
        return preparedStatement;
    }

    protected PreparedStatement deleteToken(Connection connection, String processorName, int segment) throws SQLException {
        String sql = "DELETE FROM " + this.schema.tokenTable() + " WHERE " + this.schema.processorNameColumn() + " = ? AND " + this.schema.segmentColumn() + " = ? AND " + this.schema.ownerColum() + " = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, processorName);
        preparedStatement.setInt(2, segment);
        preparedStatement.setString(3, this.nodeId);
        return preparedStatement;
    }

    protected <T> T readSerializedData(ResultSet resultSet, String columnName) throws SQLException {
        if (byte[].class.equals(this.contentType)) {
            return (T)resultSet.getBytes(columnName);
        }
        return (T)resultSet.getObject(columnName);
    }

    protected Connection getConnection() {
        try {
            return this.connectionProvider.getConnection();
        }
        catch (SQLException e) {
            throw new JdbcException("Failed to obtain a database connection", e);
        }
    }

    public static class Builder {
        private ConnectionProvider connectionProvider;
        private Serializer serializer;
        private TokenSchema schema = new TokenSchema();
        private TemporalAmount claimTimeout = Duration.ofSeconds(10L);
        private String nodeId = ManagementFactory.getRuntimeMXBean().getName();
        private Class<?> contentType = byte[].class;

        public Builder connectionProvider(ConnectionProvider connectionProvider) {
            BuilderUtils.assertNonNull(connectionProvider, "ConnectionProvider may not be null");
            this.connectionProvider = connectionProvider;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder schema(TokenSchema schema) {
            BuilderUtils.assertNonNull(schema, "TokenSchema may not be null");
            this.schema = schema;
            return this;
        }

        public Builder claimTimeout(TemporalAmount claimTimeout) {
            BuilderUtils.assertNonNull(claimTimeout, "The claim timeout may not be null");
            this.claimTimeout = claimTimeout;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.assertNodeId(nodeId, "The nodeId may not be null or empty");
            this.nodeId = nodeId;
            return this;
        }

        public Builder contentType(Class<?> contentType) {
            BuilderUtils.assertNonNull(contentType, "The content type may not be null");
            this.contentType = contentType;
            return this;
        }

        public JdbcTokenStore build() {
            return new JdbcTokenStore(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.connectionProvider, "The ConnectionProvider is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.serializer, "The Serializer is a hard requirement and should be provided");
            this.assertNodeId(this.nodeId, "The nodeId is a hard requirement and should be provided");
        }

        private void assertNodeId(String nodeId, String exceptionMessage) {
            BuilderUtils.assertThat(nodeId, name -> Objects.nonNull(name) && !"".equals(name), exceptionMessage);
        }
    }
}

