/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.inmemory;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToInitializeTokenException;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public class InMemoryTokenStore
implements TokenStore {
    private static final GlobalSequenceTrackingToken NULL_TOKEN = new GlobalSequenceTrackingToken(-1L);
    private final Map<ProcessAndSegment, TrackingToken> tokens = new ConcurrentHashMap<ProcessAndSegment, TrackingToken>();
    private final String identifier = UUID.randomUUID().toString();

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount) throws UnableToClaimTokenException {
        this.initializeTokenSegments(processorName, segmentCount, null);
    }

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        if (this.fetchSegments(processorName).length > 0) {
            throw new UnableToClaimTokenException("Could not initialize segments. Some segments were already present.");
        }
        for (int segment = 0; segment < segmentCount; ++segment) {
            this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(initialToken, NULL_TOKEN));
        }
    }

    @Override
    public void storeToken(TrackingToken token, String processorName, int segment) {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().afterCommit(uow -> this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(token, NULL_TOKEN)));
        } else {
            this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(token, NULL_TOKEN));
        }
    }

    @Override
    public TrackingToken fetchToken(String processorName, int segment) {
        TrackingToken trackingToken = this.tokens.get(new ProcessAndSegment(processorName, segment));
        if (trackingToken == null) {
            throw new UnableToClaimTokenException("No token was initialized for segment " + segment + " for processor " + processorName);
        }
        if (NULL_TOKEN == trackingToken) {
            return null;
        }
        return trackingToken;
    }

    @Override
    public void releaseClaim(String processorName, int segment) {
    }

    @Override
    public void deleteToken(String processorName, int segment) throws UnableToClaimTokenException {
        this.tokens.remove(new ProcessAndSegment(processorName, segment));
    }

    @Override
    public void initializeSegment(TrackingToken token, String processorName, int segment) throws UnableToInitializeTokenException {
        TrackingToken previous = this.tokens.putIfAbsent(new ProcessAndSegment(processorName, segment), token == null ? NULL_TOKEN : token);
        if (previous != null) {
            throw new UnableToInitializeTokenException("Token was already present");
        }
    }

    @Override
    public boolean requiresExplicitSegmentInitialization() {
        return true;
    }

    @Override
    public int[] fetchSegments(String processorName) {
        return this.tokens.keySet().stream().filter(ps -> ((ProcessAndSegment)ps).processorName.equals(processorName)).map(ProcessAndSegment::getSegment).distinct().mapToInt(Number::intValue).sorted().toArray();
    }

    @Override
    public Optional<String> retrieveStorageIdentifier() {
        return Optional.of(this.identifier);
    }

    private static class ProcessAndSegment {
        private final String processorName;
        private final int segment;

        public ProcessAndSegment(String processorName, int segment) {
            this.processorName = processorName;
            this.segment = segment;
        }

        public int getSegment() {
            return this.segment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessAndSegment that = (ProcessAndSegment)o;
            return this.segment == that.segment && Objects.equals(this.processorName, that.processorName);
        }

        public int hashCode() {
            return Objects.hash(this.processorName, this.segment);
        }
    }
}

