/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.Objects;
import java.util.function.Predicate;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;

public abstract class BuilderUtils {
    private static final String EMPTY_STRING = "";

    private BuilderUtils() {
    }

    public static <T> void assertThat(T value, Predicate<T> assertion, String exceptionMessage) throws AxonConfigurationException {
        Assert.assertThat(value, assertion, () -> new AxonConfigurationException(exceptionMessage));
    }

    public static <T> void assertNonNull(T value, String exceptionMessage) throws AxonConfigurationException {
        BuilderUtils.assertThat(value, Objects::nonNull, exceptionMessage);
    }

    public static void assertPositive(int i, String exceptionMessage) {
        BuilderUtils.assertThat(i, number -> number >= 0, exceptionMessage);
    }

    public static void assertPositive(long l, String exceptionMessage) {
        BuilderUtils.assertThat(l, number -> number >= 0L, exceptionMessage);
    }

    public static void assertStrictPositive(int i, String exceptionMessage) {
        BuilderUtils.assertThat(i, number -> number > 0, exceptionMessage);
    }

    public static void assertStrictPositive(long l, String exceptionMessage) {
        BuilderUtils.assertThat(l, number -> number > 0L, exceptionMessage);
    }

    public static void assertNonEmpty(String string, String exceptionMessage) {
        BuilderUtils.assertThat(string, s -> Objects.nonNull(s) && !EMPTY_STRING.equals(s), exceptionMessage);
    }
}

